/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.ObjectType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaskedColumnSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="parentColumnKey")
    private final String parentColumnKey;
    @JsonProperty(value="sensitiveTypeId")
    private final String sensitiveTypeId;
    @JsonProperty(value="schemaName")
    private final String schemaName;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="objectType")
    private final ObjectType objectType;
    @JsonProperty(value="columnName")
    private final String columnName;
    @JsonProperty(value="maskingColumnGroup")
    private final String maskingColumnGroup;
    @JsonProperty(value="maskingFormatUsed")
    private final String maskingFormatUsed;
    @JsonProperty(value="totalMaskedValues")
    private final Long totalMaskedValues;

    @Deprecated
    @ConstructorProperties(value={"key", "parentColumnKey", "sensitiveTypeId", "schemaName", "objectName", "objectType", "columnName", "maskingColumnGroup", "maskingFormatUsed", "totalMaskedValues"})
    public MaskedColumnSummary(String key, String parentColumnKey, String sensitiveTypeId, String schemaName, String objectName, ObjectType objectType, String columnName, String maskingColumnGroup, String maskingFormatUsed, Long totalMaskedValues) {
        this.key = key;
        this.parentColumnKey = parentColumnKey;
        this.sensitiveTypeId = sensitiveTypeId;
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.objectType = objectType;
        this.columnName = columnName;
        this.maskingColumnGroup = maskingColumnGroup;
        this.maskingFormatUsed = maskingFormatUsed;
        this.totalMaskedValues = totalMaskedValues;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getParentColumnKey() {
        return this.parentColumnKey;
    }

    public String getSensitiveTypeId() {
        return this.sensitiveTypeId;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getMaskingColumnGroup() {
        return this.maskingColumnGroup;
    }

    public String getMaskingFormatUsed() {
        return this.maskingFormatUsed;
    }

    public Long getTotalMaskedValues() {
        return this.totalMaskedValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaskedColumnSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", parentColumnKey=").append(String.valueOf(this.parentColumnKey));
        sb.append(", sensitiveTypeId=").append(String.valueOf(this.sensitiveTypeId));
        sb.append(", schemaName=").append(String.valueOf(this.schemaName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", objectType=").append(String.valueOf((Object)this.objectType));
        sb.append(", columnName=").append(String.valueOf(this.columnName));
        sb.append(", maskingColumnGroup=").append(String.valueOf(this.maskingColumnGroup));
        sb.append(", maskingFormatUsed=").append(String.valueOf(this.maskingFormatUsed));
        sb.append(", totalMaskedValues=").append(String.valueOf(this.totalMaskedValues));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaskedColumnSummary)) {
            return false;
        }
        MaskedColumnSummary other = (MaskedColumnSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.parentColumnKey, other.parentColumnKey) && Objects.equals(this.sensitiveTypeId, other.sensitiveTypeId) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.objectName, other.objectName) && Objects.equals((Object)this.objectType, (Object)other.objectType) && Objects.equals(this.columnName, other.columnName) && Objects.equals(this.maskingColumnGroup, other.maskingColumnGroup) && Objects.equals(this.maskingFormatUsed, other.maskingFormatUsed) && Objects.equals(this.totalMaskedValues, other.totalMaskedValues) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.parentColumnKey == null ? 43 : this.parentColumnKey.hashCode());
        result = result * 59 + (this.sensitiveTypeId == null ? 43 : this.sensitiveTypeId.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.maskingColumnGroup == null ? 43 : this.maskingColumnGroup.hashCode());
        result = result * 59 + (this.maskingFormatUsed == null ? 43 : this.maskingFormatUsed.hashCode());
        result = result * 59 + (this.totalMaskedValues == null ? 43 : this.totalMaskedValues.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="parentColumnKey")
        private String parentColumnKey;
        @JsonProperty(value="sensitiveTypeId")
        private String sensitiveTypeId;
        @JsonProperty(value="schemaName")
        private String schemaName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="objectType")
        private ObjectType objectType;
        @JsonProperty(value="columnName")
        private String columnName;
        @JsonProperty(value="maskingColumnGroup")
        private String maskingColumnGroup;
        @JsonProperty(value="maskingFormatUsed")
        private String maskingFormatUsed;
        @JsonProperty(value="totalMaskedValues")
        private Long totalMaskedValues;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder parentColumnKey(String parentColumnKey) {
            this.parentColumnKey = parentColumnKey;
            this.__explicitlySet__.add("parentColumnKey");
            return this;
        }

        public Builder sensitiveTypeId(String sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            this.__explicitlySet__.add("sensitiveTypeId");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.__explicitlySet__.add("schemaName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.__explicitlySet__.add("columnName");
            return this;
        }

        public Builder maskingColumnGroup(String maskingColumnGroup) {
            this.maskingColumnGroup = maskingColumnGroup;
            this.__explicitlySet__.add("maskingColumnGroup");
            return this;
        }

        public Builder maskingFormatUsed(String maskingFormatUsed) {
            this.maskingFormatUsed = maskingFormatUsed;
            this.__explicitlySet__.add("maskingFormatUsed");
            return this;
        }

        public Builder totalMaskedValues(Long totalMaskedValues) {
            this.totalMaskedValues = totalMaskedValues;
            this.__explicitlySet__.add("totalMaskedValues");
            return this;
        }

        public MaskedColumnSummary build() {
            MaskedColumnSummary model = new MaskedColumnSummary(this.key, this.parentColumnKey, this.sensitiveTypeId, this.schemaName, this.objectName, this.objectType, this.columnName, this.maskingColumnGroup, this.maskingFormatUsed, this.totalMaskedValues);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaskedColumnSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("parentColumnKey")) {
                this.parentColumnKey(model.getParentColumnKey());
            }
            if (model.wasPropertyExplicitlySet("sensitiveTypeId")) {
                this.sensitiveTypeId(model.getSensitiveTypeId());
            }
            if (model.wasPropertyExplicitlySet("schemaName")) {
                this.schemaName(model.getSchemaName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("columnName")) {
                this.columnName(model.getColumnName());
            }
            if (model.wasPropertyExplicitlySet("maskingColumnGroup")) {
                this.maskingColumnGroup(model.getMaskingColumnGroup());
            }
            if (model.wasPropertyExplicitlySet("maskingFormatUsed")) {
                this.maskingFormatUsed(model.getMaskingFormatUsed());
            }
            if (model.wasPropertyExplicitlySet("totalMaskedValues")) {
                this.totalMaskedValues(model.getTotalMaskedValues());
            }
            return this;
        }
    }
}

