/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.ModifiedAttributes;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiscoveryJobResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="discoveryType")
    private final DiscoveryType discoveryType;
    @JsonProperty(value="sensitiveColumnkey")
    private final String sensitiveColumnkey;
    @JsonProperty(value="appName")
    private final String appName;
    @JsonProperty(value="schemaName")
    private final String schemaName;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="columnName")
    private final String columnName;
    @JsonProperty(value="objectType")
    private final ObjectType objectType;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="sensitiveTypeId")
    private final String sensitiveTypeId;
    @JsonProperty(value="parentColumnKeys")
    private final List<String> parentColumnKeys;
    @JsonProperty(value="relationType")
    private final RelationType relationType;
    @JsonProperty(value="estimatedDataValueCount")
    private final Long estimatedDataValueCount;
    @JsonProperty(value="sampleDataValues")
    private final List<String> sampleDataValues;
    @JsonProperty(value="appDefinedChildColumnKeys")
    private final List<String> appDefinedChildColumnKeys;
    @JsonProperty(value="dbDefinedChildColumnKeys")
    private final List<String> dbDefinedChildColumnKeys;
    @JsonProperty(value="plannedAction")
    private final PlannedAction plannedAction;
    @JsonProperty(value="isResultApplied")
    private final Boolean isResultApplied;
    @JsonProperty(value="discoveryJobId")
    private final String discoveryJobId;
    @JsonProperty(value="modifiedAttributes")
    private final ModifiedAttributes modifiedAttributes;

    @Deprecated
    @ConstructorProperties(value={"key", "discoveryType", "sensitiveColumnkey", "appName", "schemaName", "objectName", "columnName", "objectType", "dataType", "sensitiveTypeId", "parentColumnKeys", "relationType", "estimatedDataValueCount", "sampleDataValues", "appDefinedChildColumnKeys", "dbDefinedChildColumnKeys", "plannedAction", "isResultApplied", "discoveryJobId", "modifiedAttributes"})
    public DiscoveryJobResult(String key, DiscoveryType discoveryType, String sensitiveColumnkey, String appName, String schemaName, String objectName, String columnName, ObjectType objectType, String dataType, String sensitiveTypeId, List<String> parentColumnKeys, RelationType relationType, Long estimatedDataValueCount, List<String> sampleDataValues, List<String> appDefinedChildColumnKeys, List<String> dbDefinedChildColumnKeys, PlannedAction plannedAction, Boolean isResultApplied, String discoveryJobId, ModifiedAttributes modifiedAttributes) {
        this.key = key;
        this.discoveryType = discoveryType;
        this.sensitiveColumnkey = sensitiveColumnkey;
        this.appName = appName;
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.columnName = columnName;
        this.objectType = objectType;
        this.dataType = dataType;
        this.sensitiveTypeId = sensitiveTypeId;
        this.parentColumnKeys = parentColumnKeys;
        this.relationType = relationType;
        this.estimatedDataValueCount = estimatedDataValueCount;
        this.sampleDataValues = sampleDataValues;
        this.appDefinedChildColumnKeys = appDefinedChildColumnKeys;
        this.dbDefinedChildColumnKeys = dbDefinedChildColumnKeys;
        this.plannedAction = plannedAction;
        this.isResultApplied = isResultApplied;
        this.discoveryJobId = discoveryJobId;
        this.modifiedAttributes = modifiedAttributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public DiscoveryType getDiscoveryType() {
        return this.discoveryType;
    }

    public String getSensitiveColumnkey() {
        return this.sensitiveColumnkey;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getSensitiveTypeId() {
        return this.sensitiveTypeId;
    }

    public List<String> getParentColumnKeys() {
        return this.parentColumnKeys;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public Long getEstimatedDataValueCount() {
        return this.estimatedDataValueCount;
    }

    public List<String> getSampleDataValues() {
        return this.sampleDataValues;
    }

    public List<String> getAppDefinedChildColumnKeys() {
        return this.appDefinedChildColumnKeys;
    }

    public List<String> getDbDefinedChildColumnKeys() {
        return this.dbDefinedChildColumnKeys;
    }

    public PlannedAction getPlannedAction() {
        return this.plannedAction;
    }

    public Boolean getIsResultApplied() {
        return this.isResultApplied;
    }

    public String getDiscoveryJobId() {
        return this.discoveryJobId;
    }

    public ModifiedAttributes getModifiedAttributes() {
        return this.modifiedAttributes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiscoveryJobResult(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", discoveryType=").append(String.valueOf((Object)this.discoveryType));
        sb.append(", sensitiveColumnkey=").append(String.valueOf(this.sensitiveColumnkey));
        sb.append(", appName=").append(String.valueOf(this.appName));
        sb.append(", schemaName=").append(String.valueOf(this.schemaName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", columnName=").append(String.valueOf(this.columnName));
        sb.append(", objectType=").append(String.valueOf((Object)this.objectType));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", sensitiveTypeId=").append(String.valueOf(this.sensitiveTypeId));
        sb.append(", parentColumnKeys=").append(String.valueOf(this.parentColumnKeys));
        sb.append(", relationType=").append(String.valueOf((Object)this.relationType));
        sb.append(", estimatedDataValueCount=").append(String.valueOf(this.estimatedDataValueCount));
        sb.append(", sampleDataValues=").append(String.valueOf(this.sampleDataValues));
        sb.append(", appDefinedChildColumnKeys=").append(String.valueOf(this.appDefinedChildColumnKeys));
        sb.append(", dbDefinedChildColumnKeys=").append(String.valueOf(this.dbDefinedChildColumnKeys));
        sb.append(", plannedAction=").append(String.valueOf((Object)this.plannedAction));
        sb.append(", isResultApplied=").append(String.valueOf(this.isResultApplied));
        sb.append(", discoveryJobId=").append(String.valueOf(this.discoveryJobId));
        sb.append(", modifiedAttributes=").append(String.valueOf((Object)this.modifiedAttributes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiscoveryJobResult)) {
            return false;
        }
        DiscoveryJobResult other = (DiscoveryJobResult)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals((Object)this.discoveryType, (Object)other.discoveryType) && Objects.equals(this.sensitiveColumnkey, other.sensitiveColumnkey) && Objects.equals(this.appName, other.appName) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.columnName, other.columnName) && Objects.equals((Object)this.objectType, (Object)other.objectType) && Objects.equals(this.dataType, other.dataType) && Objects.equals(this.sensitiveTypeId, other.sensitiveTypeId) && Objects.equals(this.parentColumnKeys, other.parentColumnKeys) && Objects.equals((Object)this.relationType, (Object)other.relationType) && Objects.equals(this.estimatedDataValueCount, other.estimatedDataValueCount) && Objects.equals(this.sampleDataValues, other.sampleDataValues) && Objects.equals(this.appDefinedChildColumnKeys, other.appDefinedChildColumnKeys) && Objects.equals(this.dbDefinedChildColumnKeys, other.dbDefinedChildColumnKeys) && Objects.equals((Object)this.plannedAction, (Object)other.plannedAction) && Objects.equals(this.isResultApplied, other.isResultApplied) && Objects.equals(this.discoveryJobId, other.discoveryJobId) && Objects.equals((Object)this.modifiedAttributes, (Object)other.modifiedAttributes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.discoveryType == null ? 43 : this.discoveryType.hashCode());
        result = result * 59 + (this.sensitiveColumnkey == null ? 43 : this.sensitiveColumnkey.hashCode());
        result = result * 59 + (this.appName == null ? 43 : this.appName.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.sensitiveTypeId == null ? 43 : this.sensitiveTypeId.hashCode());
        result = result * 59 + (this.parentColumnKeys == null ? 43 : this.parentColumnKeys.hashCode());
        result = result * 59 + (this.relationType == null ? 43 : this.relationType.hashCode());
        result = result * 59 + (this.estimatedDataValueCount == null ? 43 : this.estimatedDataValueCount.hashCode());
        result = result * 59 + (this.sampleDataValues == null ? 43 : this.sampleDataValues.hashCode());
        result = result * 59 + (this.appDefinedChildColumnKeys == null ? 43 : this.appDefinedChildColumnKeys.hashCode());
        result = result * 59 + (this.dbDefinedChildColumnKeys == null ? 43 : this.dbDefinedChildColumnKeys.hashCode());
        result = result * 59 + (this.plannedAction == null ? 43 : this.plannedAction.hashCode());
        result = result * 59 + (this.isResultApplied == null ? 43 : this.isResultApplied.hashCode());
        result = result * 59 + (this.discoveryJobId == null ? 43 : this.discoveryJobId.hashCode());
        result = result * 59 + (this.modifiedAttributes == null ? 43 : this.modifiedAttributes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PlannedAction implements BmcEnum
    {
        None("NONE"),
        Accept("ACCEPT"),
        Invalidate("INVALIDATE"),
        Reject("REJECT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PlannedAction> map;

        private PlannedAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlannedAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PlannedAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PlannedAction.class);
            map = new HashMap<String, PlannedAction>();
            for (PlannedAction v : PlannedAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RelationType implements BmcEnum
    {
        None("NONE"),
        AppDefined("APP_DEFINED"),
        DbDefined("DB_DEFINED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RelationType> map;

        private RelationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RelationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RelationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RelationType.class);
            map = new HashMap<String, RelationType>();
            for (RelationType v : RelationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ObjectType implements BmcEnum
    {
        Table("TABLE"),
        EditioningView("EDITIONING_VIEW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ObjectType> map;

        private ObjectType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ObjectType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ObjectType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ObjectType.class);
            map = new HashMap<String, ObjectType>();
            for (ObjectType v : ObjectType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DiscoveryType implements BmcEnum
    {
        New("NEW"),
        Modified("MODIFIED"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DiscoveryType> map;

        private DiscoveryType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiscoveryType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DiscoveryType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DiscoveryType.class);
            map = new HashMap<String, DiscoveryType>();
            for (DiscoveryType v : DiscoveryType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="discoveryType")
        private DiscoveryType discoveryType;
        @JsonProperty(value="sensitiveColumnkey")
        private String sensitiveColumnkey;
        @JsonProperty(value="appName")
        private String appName;
        @JsonProperty(value="schemaName")
        private String schemaName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="columnName")
        private String columnName;
        @JsonProperty(value="objectType")
        private ObjectType objectType;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="sensitiveTypeId")
        private String sensitiveTypeId;
        @JsonProperty(value="parentColumnKeys")
        private List<String> parentColumnKeys;
        @JsonProperty(value="relationType")
        private RelationType relationType;
        @JsonProperty(value="estimatedDataValueCount")
        private Long estimatedDataValueCount;
        @JsonProperty(value="sampleDataValues")
        private List<String> sampleDataValues;
        @JsonProperty(value="appDefinedChildColumnKeys")
        private List<String> appDefinedChildColumnKeys;
        @JsonProperty(value="dbDefinedChildColumnKeys")
        private List<String> dbDefinedChildColumnKeys;
        @JsonProperty(value="plannedAction")
        private PlannedAction plannedAction;
        @JsonProperty(value="isResultApplied")
        private Boolean isResultApplied;
        @JsonProperty(value="discoveryJobId")
        private String discoveryJobId;
        @JsonProperty(value="modifiedAttributes")
        private ModifiedAttributes modifiedAttributes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType = discoveryType;
            this.__explicitlySet__.add("discoveryType");
            return this;
        }

        public Builder sensitiveColumnkey(String sensitiveColumnkey) {
            this.sensitiveColumnkey = sensitiveColumnkey;
            this.__explicitlySet__.add("sensitiveColumnkey");
            return this;
        }

        public Builder appName(String appName) {
            this.appName = appName;
            this.__explicitlySet__.add("appName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.__explicitlySet__.add("schemaName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.__explicitlySet__.add("columnName");
            return this;
        }

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder sensitiveTypeId(String sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            this.__explicitlySet__.add("sensitiveTypeId");
            return this;
        }

        public Builder parentColumnKeys(List<String> parentColumnKeys) {
            this.parentColumnKeys = parentColumnKeys;
            this.__explicitlySet__.add("parentColumnKeys");
            return this;
        }

        public Builder relationType(RelationType relationType) {
            this.relationType = relationType;
            this.__explicitlySet__.add("relationType");
            return this;
        }

        public Builder estimatedDataValueCount(Long estimatedDataValueCount) {
            this.estimatedDataValueCount = estimatedDataValueCount;
            this.__explicitlySet__.add("estimatedDataValueCount");
            return this;
        }

        public Builder sampleDataValues(List<String> sampleDataValues) {
            this.sampleDataValues = sampleDataValues;
            this.__explicitlySet__.add("sampleDataValues");
            return this;
        }

        public Builder appDefinedChildColumnKeys(List<String> appDefinedChildColumnKeys) {
            this.appDefinedChildColumnKeys = appDefinedChildColumnKeys;
            this.__explicitlySet__.add("appDefinedChildColumnKeys");
            return this;
        }

        public Builder dbDefinedChildColumnKeys(List<String> dbDefinedChildColumnKeys) {
            this.dbDefinedChildColumnKeys = dbDefinedChildColumnKeys;
            this.__explicitlySet__.add("dbDefinedChildColumnKeys");
            return this;
        }

        public Builder plannedAction(PlannedAction plannedAction) {
            this.plannedAction = plannedAction;
            this.__explicitlySet__.add("plannedAction");
            return this;
        }

        public Builder isResultApplied(Boolean isResultApplied) {
            this.isResultApplied = isResultApplied;
            this.__explicitlySet__.add("isResultApplied");
            return this;
        }

        public Builder discoveryJobId(String discoveryJobId) {
            this.discoveryJobId = discoveryJobId;
            this.__explicitlySet__.add("discoveryJobId");
            return this;
        }

        public Builder modifiedAttributes(ModifiedAttributes modifiedAttributes) {
            this.modifiedAttributes = modifiedAttributes;
            this.__explicitlySet__.add("modifiedAttributes");
            return this;
        }

        public DiscoveryJobResult build() {
            DiscoveryJobResult model = new DiscoveryJobResult(this.key, this.discoveryType, this.sensitiveColumnkey, this.appName, this.schemaName, this.objectName, this.columnName, this.objectType, this.dataType, this.sensitiveTypeId, this.parentColumnKeys, this.relationType, this.estimatedDataValueCount, this.sampleDataValues, this.appDefinedChildColumnKeys, this.dbDefinedChildColumnKeys, this.plannedAction, this.isResultApplied, this.discoveryJobId, this.modifiedAttributes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiscoveryJobResult model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("discoveryType")) {
                this.discoveryType(model.getDiscoveryType());
            }
            if (model.wasPropertyExplicitlySet("sensitiveColumnkey")) {
                this.sensitiveColumnkey(model.getSensitiveColumnkey());
            }
            if (model.wasPropertyExplicitlySet("appName")) {
                this.appName(model.getAppName());
            }
            if (model.wasPropertyExplicitlySet("schemaName")) {
                this.schemaName(model.getSchemaName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("columnName")) {
                this.columnName(model.getColumnName());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("sensitiveTypeId")) {
                this.sensitiveTypeId(model.getSensitiveTypeId());
            }
            if (model.wasPropertyExplicitlySet("parentColumnKeys")) {
                this.parentColumnKeys(model.getParentColumnKeys());
            }
            if (model.wasPropertyExplicitlySet("relationType")) {
                this.relationType(model.getRelationType());
            }
            if (model.wasPropertyExplicitlySet("estimatedDataValueCount")) {
                this.estimatedDataValueCount(model.getEstimatedDataValueCount());
            }
            if (model.wasPropertyExplicitlySet("sampleDataValues")) {
                this.sampleDataValues(model.getSampleDataValues());
            }
            if (model.wasPropertyExplicitlySet("appDefinedChildColumnKeys")) {
                this.appDefinedChildColumnKeys(model.getAppDefinedChildColumnKeys());
            }
            if (model.wasPropertyExplicitlySet("dbDefinedChildColumnKeys")) {
                this.dbDefinedChildColumnKeys(model.getDbDefinedChildColumnKeys());
            }
            if (model.wasPropertyExplicitlySet("plannedAction")) {
                this.plannedAction(model.getPlannedAction());
            }
            if (model.wasPropertyExplicitlySet("isResultApplied")) {
                this.isResultApplied(model.getIsResultApplied());
            }
            if (model.wasPropertyExplicitlySet("discoveryJobId")) {
                this.discoveryJobId(model.getDiscoveryJobId());
            }
            if (model.wasPropertyExplicitlySet("modifiedAttributes")) {
                this.modifiedAttributes(model.getModifiedAttributes());
            }
            return this;
        }
    }
}

