/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ColumnFilter
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fieldName")
    private final String fieldName;
    @JsonProperty(value="operator")
    private final Operator operator;
    @JsonProperty(value="expressions")
    private final List<String> expressions;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="isHidden")
    private final Boolean isHidden;

    @Deprecated
    @ConstructorProperties(value={"fieldName", "operator", "expressions", "isEnabled", "isHidden"})
    public ColumnFilter(String fieldName, Operator operator, List<String> expressions, Boolean isEnabled, Boolean isHidden) {
        this.fieldName = fieldName;
        this.operator = operator;
        this.expressions = expressions;
        this.isEnabled = isEnabled;
        this.isHidden = isHidden;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<String> getExpressions() {
        return this.expressions;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Boolean getIsHidden() {
        return this.isHidden;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ColumnFilter(");
        sb.append("super=").append(super.toString());
        sb.append("fieldName=").append(String.valueOf(this.fieldName));
        sb.append(", operator=").append(String.valueOf((Object)this.operator));
        sb.append(", expressions=").append(String.valueOf(this.expressions));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", isHidden=").append(String.valueOf(this.isHidden));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnFilter)) {
            return false;
        }
        ColumnFilter other = (ColumnFilter)((Object)o);
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.expressions, other.expressions) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.isHidden, other.isHidden) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fieldName == null ? 43 : this.fieldName.hashCode());
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        result = result * 59 + (this.expressions == null ? 43 : this.expressions.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.isHidden == null ? 43 : this.isHidden.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Operator implements BmcEnum
    {
        In("IN"),
        Eq("EQ"),
        Gt("GT"),
        Ge("GE"),
        Lt("LT"),
        Le("LE"),
        And("AND"),
        Or("OR"),
        Ne("NE"),
        Co("CO"),
        Not("NOT"),
        NotIn("NOT_IN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Operator> map;

        private Operator(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Operator create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Operator', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Operator.class);
            map = new HashMap<String, Operator>();
            for (Operator v : Operator.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fieldName")
        private String fieldName;
        @JsonProperty(value="operator")
        private Operator operator;
        @JsonProperty(value="expressions")
        private List<String> expressions;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="isHidden")
        private Boolean isHidden;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.__explicitlySet__.add("fieldName");
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public Builder expressions(List<String> expressions) {
            this.expressions = expressions;
            this.__explicitlySet__.add("expressions");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.__explicitlySet__.add("isHidden");
            return this;
        }

        public ColumnFilter build() {
            ColumnFilter model = new ColumnFilter(this.fieldName, this.operator, this.expressions, this.isEnabled, this.isHidden);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ColumnFilter model) {
            if (model.wasPropertyExplicitlySet("fieldName")) {
                this.fieldName(model.getFieldName());
            }
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            if (model.wasPropertyExplicitlySet("expressions")) {
                this.expressions(model.getExpressions());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("isHidden")) {
                this.isHidden(model.getIsHidden());
            }
            return this;
        }
    }
}

