/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservicedataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datalabelingservicedataplane.model.Entity;
import com.oracle.bmc.datalabelingservicedataplane.model.Label;
import com.oracle.bmc.datalabelingservicedataplane.model.TextSpan;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityType")
@JsonFilter(value="explicitlySetFilter")
public final class TextSelectionEntity
extends Entity {
    @JsonProperty(value="labels")
    private final List<Label> labels;
    @JsonProperty(value="textSpan")
    private final TextSpan textSpan;
    @JsonProperty(value="extendedMetadata")
    private final Map<String, String> extendedMetadata;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TextSelectionEntity(List<Label> labels, TextSpan textSpan, Map<String, String> extendedMetadata) {
        this.labels = labels;
        this.textSpan = textSpan;
        this.extendedMetadata = extendedMetadata;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public TextSpan getTextSpan() {
        return this.textSpan;
    }

    public Map<String, String> getExtendedMetadata() {
        return this.extendedMetadata;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TextSelectionEntity(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", labels=").append(String.valueOf(this.labels));
        sb.append(", textSpan=").append(String.valueOf((Object)this.textSpan));
        sb.append(", extendedMetadata=").append(String.valueOf(this.extendedMetadata));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextSelectionEntity)) {
            return false;
        }
        TextSelectionEntity other = (TextSelectionEntity)((Object)o);
        return Objects.equals(this.labels, other.labels) && Objects.equals((Object)this.textSpan, (Object)other.textSpan) && Objects.equals(this.extendedMetadata, other.extendedMetadata) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.labels == null ? 43 : this.labels.hashCode());
        result = result * 59 + (this.textSpan == null ? 43 : this.textSpan.hashCode());
        result = result * 59 + (this.extendedMetadata == null ? 43 : this.extendedMetadata.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="labels")
        private List<Label> labels;
        @JsonProperty(value="textSpan")
        private TextSpan textSpan;
        @JsonProperty(value="extendedMetadata")
        private Map<String, String> extendedMetadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder labels(List<Label> labels) {
            this.labels = labels;
            this.__explicitlySet__.add("labels");
            return this;
        }

        public Builder textSpan(TextSpan textSpan) {
            this.textSpan = textSpan;
            this.__explicitlySet__.add("textSpan");
            return this;
        }

        public Builder extendedMetadata(Map<String, String> extendedMetadata) {
            this.extendedMetadata = extendedMetadata;
            this.__explicitlySet__.add("extendedMetadata");
            return this;
        }

        public TextSelectionEntity build() {
            TextSelectionEntity model = new TextSelectionEntity(this.labels, this.textSpan, this.extendedMetadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TextSelectionEntity model) {
            if (model.wasPropertyExplicitlySet("labels")) {
                this.labels(model.getLabels());
            }
            if (model.wasPropertyExplicitlySet("textSpan")) {
                this.textSpan(model.getTextSpan());
            }
            if (model.wasPropertyExplicitlySet("extendedMetadata")) {
                this.extendedMetadata(model.getExtendedMetadata());
            }
            return this;
        }
    }
}

