/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservicedataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datalabelingservicedataplane.model.SourceDetails;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ObjectStorageSourceDetails
extends SourceDetails {
    @JsonProperty(value="relativePath")
    private final String relativePath;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="offset")
    private final BigDecimal offset;
    @JsonProperty(value="length")
    private final BigDecimal length;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ObjectStorageSourceDetails(String relativePath, String path, BigDecimal offset, BigDecimal length) {
        this.relativePath = relativePath;
        this.path = path;
        this.offset = offset;
        this.length = length;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getPath() {
        return this.path;
    }

    public BigDecimal getOffset() {
        return this.offset;
    }

    public BigDecimal getLength() {
        return this.length;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectStorageSourceDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", relativePath=").append(String.valueOf(this.relativePath));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", offset=").append(String.valueOf(this.offset));
        sb.append(", length=").append(String.valueOf(this.length));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectStorageSourceDetails)) {
            return false;
        }
        ObjectStorageSourceDetails other = (ObjectStorageSourceDetails)((Object)o);
        return Objects.equals(this.relativePath, other.relativePath) && Objects.equals(this.path, other.path) && Objects.equals(this.offset, other.offset) && Objects.equals(this.length, other.length) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.relativePath == null ? 43 : this.relativePath.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.offset == null ? 43 : this.offset.hashCode());
        result = result * 59 + (this.length == null ? 43 : this.length.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="relativePath")
        private String relativePath;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="offset")
        private BigDecimal offset;
        @JsonProperty(value="length")
        private BigDecimal length;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            this.__explicitlySet__.add("relativePath");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder offset(BigDecimal offset) {
            this.offset = offset;
            this.__explicitlySet__.add("offset");
            return this;
        }

        public Builder length(BigDecimal length) {
            this.length = length;
            this.__explicitlySet__.add("length");
            return this;
        }

        public ObjectStorageSourceDetails build() {
            ObjectStorageSourceDetails model = new ObjectStorageSourceDetails(this.relativePath, this.path, this.offset, this.length);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ObjectStorageSourceDetails model) {
            if (model.wasPropertyExplicitlySet("relativePath")) {
                this.relativePath(model.getRelativePath());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("offset")) {
                this.offset(model.getOffset());
            }
            if (model.wasPropertyExplicitlySet("length")) {
                this.length(model.getLength());
            }
            return this;
        }
    }
}

