/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservicedataplane;

import com.oracle.bmc.datalabelingservicedataplane.DataLabeling;
import com.oracle.bmc.datalabelingservicedataplane.model.Annotation;
import com.oracle.bmc.datalabelingservicedataplane.model.Dataset;
import com.oracle.bmc.datalabelingservicedataplane.model.Record;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetDatasetRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetDatasetResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DataLabelingWaiters {
    private final ExecutorService executorService;
    private final DataLabeling client;

    public DataLabelingWaiters(ExecutorService executorService, DataLabeling client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAnnotationRequest, GetAnnotationResponse> forAnnotation(GetAnnotationRequest request, Annotation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAnnotation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAnnotationRequest, GetAnnotationResponse> forAnnotation(GetAnnotationRequest request, Annotation.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAnnotation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAnnotationRequest, GetAnnotationResponse> forAnnotation(GetAnnotationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Annotation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAnnotation(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAnnotationRequest, GetAnnotationResponse> forAnnotation(BmcGenericWaiter waiter, GetAnnotationRequest request, Annotation.LifecycleState ... targetStates) {
        final HashSet<Annotation.LifecycleState> targetStatesSet = new HashSet<Annotation.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAnnotationRequest, GetAnnotationResponse>(){

            @Override
            public GetAnnotationResponse apply(GetAnnotationRequest request) {
                return DataLabelingWaiters.this.client.getAnnotation(request);
            }
        }, (Predicate)new Predicate<GetAnnotationResponse>(){

            @Override
            public boolean test(GetAnnotationResponse response) {
                return targetStatesSet.contains((Object)response.getAnnotation().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Annotation.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDatasetRequest, GetDatasetResponse> forDataset(GetDatasetRequest request, Dataset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataset(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatasetRequest, GetDatasetResponse> forDataset(GetDatasetRequest request, Dataset.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatasetRequest, GetDatasetResponse> forDataset(GetDatasetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Dataset.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDataset(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatasetRequest, GetDatasetResponse> forDataset(BmcGenericWaiter waiter, GetDatasetRequest request, Dataset.LifecycleState ... targetStates) {
        final HashSet<Dataset.LifecycleState> targetStatesSet = new HashSet<Dataset.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDatasetRequest, GetDatasetResponse>(){

            @Override
            public GetDatasetResponse apply(GetDatasetRequest request) {
                return DataLabelingWaiters.this.client.getDataset(request);
            }
        }, (Predicate)new Predicate<GetDatasetResponse>(){

            @Override
            public boolean test(GetDatasetResponse response) {
                return targetStatesSet.contains((Object)response.getDataset().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Dataset.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetRecordRequest, GetRecordResponse> forRecord(GetRecordRequest request, Record.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRecord(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRecordRequest, GetRecordResponse> forRecord(GetRecordRequest request, Record.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRecord(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRecordRequest, GetRecordResponse> forRecord(GetRecordRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Record.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRecord(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRecordRequest, GetRecordResponse> forRecord(BmcGenericWaiter waiter, GetRecordRequest request, Record.LifecycleState ... targetStates) {
        final HashSet<Record.LifecycleState> targetStatesSet = new HashSet<Record.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRecordRequest, GetRecordResponse>(){

            @Override
            public GetRecordResponse apply(GetRecordRequest request) {
                return DataLabelingWaiters.this.client.getRecord(request);
            }
        }, (Predicate)new Predicate<GetRecordResponse>(){

            @Override
            public boolean test(GetRecordResponse response) {
                return targetStatesSet.contains((Object)response.getRecord().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Record.LifecycleState.Deleted)), (Object)request);
    }
}

