/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservicedataplane.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datalabelingservicedataplane.model.Entity;
import com.oracle.bmc.datalabelingservicedataplane.model.Label;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entityType")
@JsonFilter(value="explicitlySetFilter")
public final class GenericEntity
extends Entity {
    @JsonProperty(value="labels")
    private final List<Label> labels;
    @JsonProperty(value="extendedMetadata")
    private final Map<String, String> extendedMetadata;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GenericEntity(List<Label> labels, Map<String, String> extendedMetadata) {
        this.labels = labels;
        this.extendedMetadata = extendedMetadata;
    }

    public List<Label> getLabels() {
        return this.labels;
    }

    public Map<String, String> getExtendedMetadata() {
        return this.extendedMetadata;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenericEntity(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", labels=").append(String.valueOf(this.labels));
        sb.append(", extendedMetadata=").append(String.valueOf(this.extendedMetadata));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericEntity)) {
            return false;
        }
        GenericEntity other = (GenericEntity)((Object)o);
        return Objects.equals(this.labels, other.labels) && Objects.equals(this.extendedMetadata, other.extendedMetadata) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.labels == null ? 43 : this.labels.hashCode());
        result = result * 59 + (this.extendedMetadata == null ? 43 : this.extendedMetadata.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="labels")
        private List<Label> labels;
        @JsonProperty(value="extendedMetadata")
        private Map<String, String> extendedMetadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder labels(List<Label> labels) {
            this.labels = labels;
            this.__explicitlySet__.add("labels");
            return this;
        }

        public Builder extendedMetadata(Map<String, String> extendedMetadata) {
            this.extendedMetadata = extendedMetadata;
            this.__explicitlySet__.add("extendedMetadata");
            return this;
        }

        public GenericEntity build() {
            GenericEntity model = new GenericEntity(this.labels, this.extendedMetadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenericEntity model) {
            if (model.wasPropertyExplicitlySet("labels")) {
                this.labels(model.getLabels());
            }
            if (model.wasPropertyExplicitlySet("extendedMetadata")) {
                this.extendedMetadata(model.getExtendedMetadata());
            }
            return this;
        }
    }
}

