/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice;

import com.oracle.bmc.datalabelingservice.DataLabelingManagement;
import com.oracle.bmc.datalabelingservice.model.AnnotationFormatSummary;
import com.oracle.bmc.datalabelingservice.model.DatasetSummary;
import com.oracle.bmc.datalabelingservice.model.WorkRequestError;
import com.oracle.bmc.datalabelingservice.model.WorkRequestLogEntry;
import com.oracle.bmc.datalabelingservice.model.WorkRequestSummary;
import com.oracle.bmc.datalabelingservice.requests.ListAnnotationFormatsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListDatasetsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datalabelingservice.responses.ListAnnotationFormatsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListDatasetsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DataLabelingManagementPaginators {
    private final DataLabelingManagement client;

    public DataLabelingManagementPaginators(DataLabelingManagement client) {
        this.client = client;
    }

    public Iterable<ListAnnotationFormatsResponse> listAnnotationFormatsResponseIterator(final ListAnnotationFormatsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAnnotationFormatsRequest.Builder>(){

            @Override
            public ListAnnotationFormatsRequest.Builder get() {
                return ListAnnotationFormatsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnotationFormatsResponse, String>(){

            @Override
            public String apply(ListAnnotationFormatsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnotationFormatsRequest.Builder>, ListAnnotationFormatsRequest>(){

            @Override
            public ListAnnotationFormatsRequest apply(RequestBuilderAndToken<ListAnnotationFormatsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAnnotationFormatsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnotationFormatsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAnnotationFormatsRequest, ListAnnotationFormatsResponse>(){

            @Override
            public ListAnnotationFormatsResponse apply(ListAnnotationFormatsRequest request) {
                return DataLabelingManagementPaginators.this.client.listAnnotationFormats(request);
            }
        });
    }

    public Iterable<AnnotationFormatSummary> listAnnotationFormatsRecordIterator(final ListAnnotationFormatsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAnnotationFormatsRequest.Builder>(){

            @Override
            public ListAnnotationFormatsRequest.Builder get() {
                return ListAnnotationFormatsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnotationFormatsResponse, String>(){

            @Override
            public String apply(ListAnnotationFormatsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnotationFormatsRequest.Builder>, ListAnnotationFormatsRequest>(){

            @Override
            public ListAnnotationFormatsRequest apply(RequestBuilderAndToken<ListAnnotationFormatsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAnnotationFormatsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnotationFormatsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAnnotationFormatsRequest, ListAnnotationFormatsResponse>(){

            @Override
            public ListAnnotationFormatsResponse apply(ListAnnotationFormatsRequest request) {
                return DataLabelingManagementPaginators.this.client.listAnnotationFormats(request);
            }
        }, (Function)new Function<ListAnnotationFormatsResponse, List<AnnotationFormatSummary>>(){

            @Override
            public List<AnnotationFormatSummary> apply(ListAnnotationFormatsResponse response) {
                return response.getAnnotationFormatCollection().getItems();
            }
        });
    }

    public Iterable<ListDatasetsResponse> listDatasetsResponseIterator(final ListDatasetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDatasetsRequest.Builder>(){

            @Override
            public ListDatasetsRequest.Builder get() {
                return ListDatasetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatasetsResponse, String>(){

            @Override
            public String apply(ListDatasetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatasetsRequest.Builder>, ListDatasetsRequest>(){

            @Override
            public ListDatasetsRequest apply(RequestBuilderAndToken<ListDatasetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatasetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatasetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatasetsRequest, ListDatasetsResponse>(){

            @Override
            public ListDatasetsResponse apply(ListDatasetsRequest request) {
                return DataLabelingManagementPaginators.this.client.listDatasets(request);
            }
        });
    }

    public Iterable<DatasetSummary> listDatasetsRecordIterator(final ListDatasetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDatasetsRequest.Builder>(){

            @Override
            public ListDatasetsRequest.Builder get() {
                return ListDatasetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatasetsResponse, String>(){

            @Override
            public String apply(ListDatasetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatasetsRequest.Builder>, ListDatasetsRequest>(){

            @Override
            public ListDatasetsRequest apply(RequestBuilderAndToken<ListDatasetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDatasetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatasetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDatasetsRequest, ListDatasetsResponse>(){

            @Override
            public ListDatasetsResponse apply(ListDatasetsRequest request) {
                return DataLabelingManagementPaginators.this.client.listDatasets(request);
            }
        }, (Function)new Function<ListDatasetsResponse, List<DatasetSummary>>(){

            @Override
            public List<DatasetSummary> apply(ListDatasetsResponse response) {
                return response.getDatasetCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataLabelingManagementPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataLabelingManagementPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataLabelingManagementPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataLabelingManagementPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataLabelingManagementPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataLabelingManagementPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

