/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datalabelingservice.DataLabelingManagementAsync;
import com.oracle.bmc.datalabelingservice.model.AnnotationFormatCollection;
import com.oracle.bmc.datalabelingservice.model.Dataset;
import com.oracle.bmc.datalabelingservice.model.DatasetCollection;
import com.oracle.bmc.datalabelingservice.model.WorkRequest;
import com.oracle.bmc.datalabelingservice.model.WorkRequestErrorCollection;
import com.oracle.bmc.datalabelingservice.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.datalabelingservice.model.WorkRequestSummaryCollection;
import com.oracle.bmc.datalabelingservice.requests.AddDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.ChangeDatasetCompartmentRequest;
import com.oracle.bmc.datalabelingservice.requests.CreateDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.DeleteDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.GenerateDatasetRecordsRequest;
import com.oracle.bmc.datalabelingservice.requests.GetDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.GetWorkRequestRequest;
import com.oracle.bmc.datalabelingservice.requests.ListAnnotationFormatsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListDatasetsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datalabelingservice.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datalabelingservice.requests.RemoveDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.RenameDatasetLabelsRequest;
import com.oracle.bmc.datalabelingservice.requests.SnapshotDatasetRequest;
import com.oracle.bmc.datalabelingservice.requests.UpdateDatasetRequest;
import com.oracle.bmc.datalabelingservice.responses.AddDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.ChangeDatasetCompartmentResponse;
import com.oracle.bmc.datalabelingservice.responses.CreateDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.DeleteDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.GenerateDatasetRecordsResponse;
import com.oracle.bmc.datalabelingservice.responses.GetDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.GetWorkRequestResponse;
import com.oracle.bmc.datalabelingservice.responses.ListAnnotationFormatsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListDatasetsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datalabelingservice.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datalabelingservice.responses.RemoveDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.RenameDatasetLabelsResponse;
import com.oracle.bmc.datalabelingservice.responses.SnapshotDatasetResponse;
import com.oracle.bmc.datalabelingservice.responses.UpdateDatasetResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLabelingManagementAsyncClient
extends BaseAsyncClient
implements DataLabelingManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATALABELINGMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://datalabeling-cp.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataLabelingManagementAsyncClient.class);

    private DataLabelingManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddDatasetLabelsResponse> addDatasetLabels(AddDatasetLabelsRequest request, AsyncHandler<AddDatasetLabelsRequest, AddDatasetLabelsResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddDatasetLabelsDetails(), "addDatasetLabelsDetails is required");
        return this.clientCall(request, AddDatasetLabelsResponse::builder).logger(LOG, "addDatasetLabels").serviceDetails("DataLabelingManagement", "AddDatasetLabels", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/AddDatasetLabels").method(Method.POST).requestBuilder(AddDatasetLabelsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("addLabels").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", AddDatasetLabelsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AddDatasetLabelsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDatasetCompartmentResponse> changeDatasetCompartment(ChangeDatasetCompartmentRequest request, AsyncHandler<ChangeDatasetCompartmentRequest, ChangeDatasetCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDatasetCompartmentDetails(), "changeDatasetCompartmentDetails is required");
        return this.clientCall(request, ChangeDatasetCompartmentResponse::builder).logger(LOG, "changeDatasetCompartment").serviceDetails("DataLabelingManagement", "ChangeDatasetCompartment", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/ChangeDatasetCompartment").method(Method.POST).requestBuilder(ChangeDatasetCompartmentRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeDatasetCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeDatasetCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDatasetResponse> createDataset(CreateDatasetRequest request, AsyncHandler<CreateDatasetRequest, CreateDatasetResponse> handler) {
        Objects.requireNonNull(request.getCreateDatasetDetails(), "createDatasetDetails is required");
        return this.clientCall(request, CreateDatasetResponse::builder).logger(LOG, "createDataset").serviceDetails("DataLabelingManagement", "CreateDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/CreateDataset").method(Method.POST).requestBuilder(CreateDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Dataset.class, CreateDatasetResponse.Builder::dataset).handleResponseHeaderString("etag", CreateDatasetResponse.Builder::etag).handleResponseHeaderString("location", CreateDatasetResponse.Builder::location).handleResponseHeaderString("Content-Location", CreateDatasetResponse.Builder::contentLocation).handleResponseHeaderString("opc-work-request-id", CreateDatasetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDatasetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest request, AsyncHandler<DeleteDatasetRequest, DeleteDatasetResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDatasetResponse::builder).logger(LOG, "deleteDataset").serviceDetails("DataLabelingManagement", "DeleteDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/DeleteDataset").method(Method.DELETE).requestBuilder(DeleteDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteDatasetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDatasetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GenerateDatasetRecordsResponse> generateDatasetRecords(GenerateDatasetRecordsRequest request, AsyncHandler<GenerateDatasetRecordsRequest, GenerateDatasetRecordsResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGenerateDatasetRecordsDetails(), "generateDatasetRecordsDetails is required");
        return this.clientCall(request, GenerateDatasetRecordsResponse::builder).logger(LOG, "generateDatasetRecords").serviceDetails("DataLabelingManagement", "GenerateDatasetRecords", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/GenerateDatasetRecords").method(Method.POST).requestBuilder(GenerateDatasetRecordsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("generateDatasetRecords").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", GenerateDatasetRecordsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", GenerateDatasetRecordsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDatasetResponse> getDataset(GetDatasetRequest request, AsyncHandler<GetDatasetRequest, GetDatasetResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDatasetResponse::builder).logger(LOG, "getDataset").serviceDetails("DataLabelingManagement", "GetDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/GetDataset").method(Method.GET).requestBuilder(GetDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Dataset.class, GetDatasetResponse.Builder::dataset).handleResponseHeaderString("etag", GetDatasetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDatasetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DataLabelingManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListAnnotationFormatsResponse> listAnnotationFormats(ListAnnotationFormatsRequest request, AsyncHandler<ListAnnotationFormatsRequest, ListAnnotationFormatsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAnnotationFormatsResponse::builder).logger(LOG, "listAnnotationFormats").serviceDetails("DataLabelingManagement", "ListAnnotationFormats", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/AnnotationFormat/ListAnnotationFormats").method(Method.GET).requestBuilder(ListAnnotationFormatsRequest::builder).basePath("/20211001").appendPathParam("annotationFormats").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnotationFormatCollection.class, ListAnnotationFormatsResponse.Builder::annotationFormatCollection).handleResponseHeaderString("opc-request-id", ListAnnotationFormatsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAnnotationFormatsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDatasetsResponse> listDatasets(ListDatasetsRequest request, AsyncHandler<ListDatasetsRequest, ListDatasetsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDatasetsResponse::builder).logger(LOG, "listDatasets").serviceDetails("DataLabelingManagement", "ListDatasets", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/DatasetCollection/ListDatasets").method(Method.GET).requestBuilder(ListDatasetsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("annotationFormat", (Object)request.getAnnotationFormat()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DatasetCollection.class, ListDatasetsResponse.Builder::datasetCollection).handleResponseHeaderString("opc-request-id", ListDatasetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDatasetsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DataLabelingManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/WorkRequest/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DataLabelingManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/WorkRequest/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DataLabelingManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20211001").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RemoveDatasetLabelsResponse> removeDatasetLabels(RemoveDatasetLabelsRequest request, AsyncHandler<RemoveDatasetLabelsRequest, RemoveDatasetLabelsResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveDatasetLabelsDetails(), "removeDatasetLabelsDetails is required");
        return this.clientCall(request, RemoveDatasetLabelsResponse::builder).logger(LOG, "removeDatasetLabels").serviceDetails("DataLabelingManagement", "RemoveDatasetLabels", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/RemoveDatasetLabels").method(Method.POST).requestBuilder(RemoveDatasetLabelsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("removeLabels").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RemoveDatasetLabelsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveDatasetLabelsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RenameDatasetLabelsResponse> renameDatasetLabels(RenameDatasetLabelsRequest request, AsyncHandler<RenameDatasetLabelsRequest, RenameDatasetLabelsResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRenameDatasetLabelsDetails(), "renameDatasetLabelsDetails is required");
        return this.clientCall(request, RenameDatasetLabelsResponse::builder).logger(LOG, "renameDatasetLabels").serviceDetails("DataLabelingManagement", "RenameDatasetLabels", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/RenameDatasetLabels").method(Method.POST).requestBuilder(RenameDatasetLabelsRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("renameLabels").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", RenameDatasetLabelsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RenameDatasetLabelsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SnapshotDatasetResponse> snapshotDataset(SnapshotDatasetRequest request, AsyncHandler<SnapshotDatasetRequest, SnapshotDatasetResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSnapshotDatasetDetails(), "snapshotDatasetDetails is required");
        return this.clientCall(request, SnapshotDatasetResponse::builder).logger(LOG, "snapshotDataset").serviceDetails("DataLabelingManagement", "SnapshotDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/SnapshotDataset").method(Method.POST).requestBuilder(SnapshotDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).appendPathParam("actions").appendPathParam("snapshot").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", SnapshotDatasetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", SnapshotDatasetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDatasetResponse> updateDataset(UpdateDatasetRequest request, AsyncHandler<UpdateDatasetRequest, UpdateDatasetResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDatasetDetails(), "updateDatasetDetails is required");
        return this.clientCall(request, UpdateDatasetResponse::builder).logger(LOG, "updateDataset").serviceDetails("DataLabelingManagement", "UpdateDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling/20211001/Dataset/UpdateDataset").method(Method.PUT).requestBuilder(UpdateDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Dataset.class, UpdateDatasetResponse.Builder::dataset).handleResponseHeaderString("etag", UpdateDatasetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDatasetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DataLabelingManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataLabelingManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataLabelingManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataLabelingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataLabelingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataLabelingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataLabelingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataLabelingManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataLabelingManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataLabelingManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataLabelingManagementAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

