/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateProjectDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateProjectRequest
extends BmcRequest<UpdateProjectDetails> {
    private String workspaceId;
    private String projectKey;
    private UpdateProjectDetails updateProjectDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public UpdateProjectDetails getUpdateProjectDetails() {
        return this.updateProjectDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateProjectDetails getBody$() {
        return this.updateProjectDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).projectKey(this.projectKey).updateProjectDetails(this.updateProjectDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",projectKey=").append(String.valueOf(this.projectKey));
        sb.append(",updateProjectDetails=").append(String.valueOf((Object)this.updateProjectDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.projectKey, other.projectKey) && Objects.equals((Object)this.updateProjectDetails, (Object)other.updateProjectDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.projectKey == null ? 43 : this.projectKey.hashCode());
        result = result * 59 + (this.updateProjectDetails == null ? 43 : this.updateProjectDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateProjectRequest, UpdateProjectDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String projectKey = null;
        private UpdateProjectDetails updateProjectDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public Builder updateProjectDetails(UpdateProjectDetails updateProjectDetails) {
            this.updateProjectDetails = updateProjectDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateProjectRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.projectKey(o.getProjectKey());
            this.updateProjectDetails(o.getUpdateProjectDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateProjectRequest build() {
            UpdateProjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateProjectDetails body) {
            this.updateProjectDetails(body);
            return this;
        }

        public UpdateProjectRequest buildWithoutInvocationCallback() {
            UpdateProjectRequest request = new UpdateProjectRequest();
            request.workspaceId = this.workspaceId;
            request.projectKey = this.projectKey;
            request.updateProjectDetails = this.updateProjectDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

