/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataintegration.model.UpdateFunctionLibraryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateFunctionLibraryRequest
extends BmcRequest<UpdateFunctionLibraryDetails> {
    private String workspaceId;
    private String functionLibraryKey;
    private UpdateFunctionLibraryDetails updateFunctionLibraryDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getFunctionLibraryKey() {
        return this.functionLibraryKey;
    }

    public UpdateFunctionLibraryDetails getUpdateFunctionLibraryDetails() {
        return this.updateFunctionLibraryDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateFunctionLibraryDetails getBody$() {
        return this.updateFunctionLibraryDetails;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).functionLibraryKey(this.functionLibraryKey).updateFunctionLibraryDetails(this.updateFunctionLibraryDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",functionLibraryKey=").append(String.valueOf(this.functionLibraryKey));
        sb.append(",updateFunctionLibraryDetails=").append(String.valueOf((Object)this.updateFunctionLibraryDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateFunctionLibraryRequest)) {
            return false;
        }
        UpdateFunctionLibraryRequest other = (UpdateFunctionLibraryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.functionLibraryKey, other.functionLibraryKey) && Objects.equals((Object)this.updateFunctionLibraryDetails, (Object)other.updateFunctionLibraryDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.functionLibraryKey == null ? 43 : this.functionLibraryKey.hashCode());
        result = result * 59 + (this.updateFunctionLibraryDetails == null ? 43 : this.updateFunctionLibraryDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateFunctionLibraryRequest, UpdateFunctionLibraryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String functionLibraryKey = null;
        private UpdateFunctionLibraryDetails updateFunctionLibraryDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder functionLibraryKey(String functionLibraryKey) {
            this.functionLibraryKey = functionLibraryKey;
            return this;
        }

        public Builder updateFunctionLibraryDetails(UpdateFunctionLibraryDetails updateFunctionLibraryDetails) {
            this.updateFunctionLibraryDetails = updateFunctionLibraryDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateFunctionLibraryRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.functionLibraryKey(o.getFunctionLibraryKey());
            this.updateFunctionLibraryDetails(o.getUpdateFunctionLibraryDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateFunctionLibraryRequest build() {
            UpdateFunctionLibraryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateFunctionLibraryDetails body) {
            this.updateFunctionLibraryDetails(body);
            return this;
        }

        public UpdateFunctionLibraryRequest buildWithoutInvocationCallback() {
            UpdateFunctionLibraryRequest request = new UpdateFunctionLibraryRequest();
            request.workspaceId = this.workspaceId;
            request.functionLibraryKey = this.functionLibraryKey;
            request.updateFunctionLibraryDetails = this.updateFunctionLibraryDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

