/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRuntimePipelineRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String runtimePipelineKey;
    private String opcRequestId;
    private String expandReferences;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getRuntimePipelineKey() {
        return this.runtimePipelineKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getExpandReferences() {
        return this.expandReferences;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).applicationKey(this.applicationKey).runtimePipelineKey(this.runtimePipelineKey).opcRequestId(this.opcRequestId).expandReferences(this.expandReferences);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(",runtimePipelineKey=").append(String.valueOf(this.runtimePipelineKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",expandReferences=").append(String.valueOf(this.expandReferences));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRuntimePipelineRequest)) {
            return false;
        }
        GetRuntimePipelineRequest other = (GetRuntimePipelineRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.runtimePipelineKey, other.runtimePipelineKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.expandReferences, other.expandReferences);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.runtimePipelineKey == null ? 43 : this.runtimePipelineKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.expandReferences == null ? 43 : this.expandReferences.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRuntimePipelineRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String applicationKey = null;
        private String runtimePipelineKey = null;
        private String opcRequestId = null;
        private String expandReferences = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder runtimePipelineKey(String runtimePipelineKey) {
            this.runtimePipelineKey = runtimePipelineKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder expandReferences(String expandReferences) {
            this.expandReferences = expandReferences;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRuntimePipelineRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.runtimePipelineKey(o.getRuntimePipelineKey());
            this.opcRequestId(o.getOpcRequestId());
            this.expandReferences(o.getExpandReferences());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRuntimePipelineRequest build() {
            GetRuntimePipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRuntimePipelineRequest buildWithoutInvocationCallback() {
            GetRuntimePipelineRequest request = new GetRuntimePipelineRequest();
            request.workspaceId = this.workspaceId;
            request.applicationKey = this.applicationKey;
            request.runtimePipelineKey = this.runtimePipelineKey;
            request.opcRequestId = this.opcRequestId;
            request.expandReferences = this.expandReferences;
            return request;
        }
    }
}

