/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRuntimeOperatorRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String applicationKey;
    private String runtimePipelineKey;
    private String runtimeOperatorKey;
    private String opcRequestId;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getRuntimePipelineKey() {
        return this.runtimePipelineKey;
    }

    public String getRuntimeOperatorKey() {
        return this.runtimeOperatorKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).applicationKey(this.applicationKey).runtimePipelineKey(this.runtimePipelineKey).runtimeOperatorKey(this.runtimeOperatorKey).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(",runtimePipelineKey=").append(String.valueOf(this.runtimePipelineKey));
        sb.append(",runtimeOperatorKey=").append(String.valueOf(this.runtimeOperatorKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRuntimeOperatorRequest)) {
            return false;
        }
        GetRuntimeOperatorRequest other = (GetRuntimeOperatorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.runtimePipelineKey, other.runtimePipelineKey) && Objects.equals(this.runtimeOperatorKey, other.runtimeOperatorKey) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.runtimePipelineKey == null ? 43 : this.runtimePipelineKey.hashCode());
        result = result * 59 + (this.runtimeOperatorKey == null ? 43 : this.runtimeOperatorKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRuntimeOperatorRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String applicationKey = null;
        private String runtimePipelineKey = null;
        private String runtimeOperatorKey = null;
        private String opcRequestId = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public Builder runtimePipelineKey(String runtimePipelineKey) {
            this.runtimePipelineKey = runtimePipelineKey;
            return this;
        }

        public Builder runtimeOperatorKey(String runtimeOperatorKey) {
            this.runtimeOperatorKey = runtimeOperatorKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRuntimeOperatorRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.applicationKey(o.getApplicationKey());
            this.runtimePipelineKey(o.getRuntimePipelineKey());
            this.runtimeOperatorKey(o.getRuntimeOperatorKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRuntimeOperatorRequest build() {
            GetRuntimeOperatorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRuntimeOperatorRequest buildWithoutInvocationCallback() {
            GetRuntimeOperatorRequest request = new GetRuntimeOperatorRequest();
            request.workspaceId = this.workspaceId;
            request.applicationKey = this.applicationKey;
            request.runtimePipelineKey = this.runtimePipelineKey;
            request.runtimeOperatorKey = this.runtimeOperatorKey;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

