/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPipelineRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String pipelineKey;
    private String opcRequestId;
    private String expandReferences;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getPipelineKey() {
        return this.pipelineKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getExpandReferences() {
        return this.expandReferences;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).pipelineKey(this.pipelineKey).opcRequestId(this.opcRequestId).expandReferences(this.expandReferences);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",pipelineKey=").append(String.valueOf(this.pipelineKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",expandReferences=").append(String.valueOf(this.expandReferences));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPipelineRequest)) {
            return false;
        }
        GetPipelineRequest other = (GetPipelineRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.pipelineKey, other.pipelineKey) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.expandReferences, other.expandReferences);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.pipelineKey == null ? 43 : this.pipelineKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.expandReferences == null ? 43 : this.expandReferences.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPipelineRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String pipelineKey = null;
        private String opcRequestId = null;
        private String expandReferences = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder pipelineKey(String pipelineKey) {
            this.pipelineKey = pipelineKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder expandReferences(String expandReferences) {
            this.expandReferences = expandReferences;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPipelineRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.pipelineKey(o.getPipelineKey());
            this.opcRequestId(o.getOpcRequestId());
            this.expandReferences(o.getExpandReferences());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPipelineRequest build() {
            GetPipelineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPipelineRequest buildWithoutInvocationCallback() {
            GetPipelineRequest request = new GetPipelineRequest();
            request.workspaceId = this.workspaceId;
            request.pipelineKey = this.pipelineKey;
            request.opcRequestId = this.opcRequestId;
            request.expandReferences = this.expandReferences;
            return request;
        }
    }
}

