/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetExternalPublicationRequest
extends BmcRequest<Void> {
    private String workspaceId;
    private String taskKey;
    private String externalPublicationsKey;
    private String opcRequestId;

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public String getExternalPublicationsKey() {
        return this.externalPublicationsKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().workspaceId(this.workspaceId).taskKey(this.taskKey).externalPublicationsKey(this.externalPublicationsKey).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",workspaceId=").append(String.valueOf(this.workspaceId));
        sb.append(",taskKey=").append(String.valueOf(this.taskKey));
        sb.append(",externalPublicationsKey=").append(String.valueOf(this.externalPublicationsKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExternalPublicationRequest)) {
            return false;
        }
        GetExternalPublicationRequest other = (GetExternalPublicationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.workspaceId, other.workspaceId) && Objects.equals(this.taskKey, other.taskKey) && Objects.equals(this.externalPublicationsKey, other.externalPublicationsKey) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.workspaceId == null ? 43 : this.workspaceId.hashCode());
        result = result * 59 + (this.taskKey == null ? 43 : this.taskKey.hashCode());
        result = result * 59 + (this.externalPublicationsKey == null ? 43 : this.externalPublicationsKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExternalPublicationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String workspaceId = null;
        private String taskKey = null;
        private String externalPublicationsKey = null;
        private String opcRequestId = null;

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder taskKey(String taskKey) {
            this.taskKey = taskKey;
            return this;
        }

        public Builder externalPublicationsKey(String externalPublicationsKey) {
            this.externalPublicationsKey = externalPublicationsKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExternalPublicationRequest o) {
            this.workspaceId(o.getWorkspaceId());
            this.taskKey(o.getTaskKey());
            this.externalPublicationsKey(o.getExternalPublicationsKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExternalPublicationRequest build() {
            GetExternalPublicationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExternalPublicationRequest buildWithoutInvocationCallback() {
            GetExternalPublicationRequest request = new GetExternalPublicationRequest();
            request.workspaceId = this.workspaceId;
            request.taskKey = this.taskKey;
            request.externalPublicationsKey = this.externalPublicationsKey;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

