/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigProvider;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.Operator;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.Task;
import com.oracle.bmc.dataintegration.model.TypedObject;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class TaskOperator
extends Operator {
    @JsonProperty(value="retryAttempts")
    private final Integer retryAttempts;
    @JsonProperty(value="retryDelayUnit")
    private final RetryDelayUnit retryDelayUnit;
    @JsonProperty(value="retryDelay")
    private final Double retryDelay;
    @JsonProperty(value="expectedDuration")
    private final Double expectedDuration;
    @JsonProperty(value="expectedDurationUnit")
    private final ExpectedDurationUnit expectedDurationUnit;
    @JsonProperty(value="taskType")
    private final TaskType taskType;
    @JsonProperty(value="task")
    private final Task task;
    @JsonProperty(value="triggerRule")
    private final TriggerRule triggerRule;
    @JsonProperty(value="configProviderDelegate")
    private final ConfigProvider configProviderDelegate;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public TaskOperator(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, List<InputPort> inputPorts, List<TypedObject> outputPorts, Integer objectStatus, String identifier, List<Parameter> parameters, ConfigValues opConfigValues, Integer retryAttempts, RetryDelayUnit retryDelayUnit, Double retryDelay, Double expectedDuration, ExpectedDurationUnit expectedDurationUnit, TaskType taskType, Task task, TriggerRule triggerRule, ConfigProvider configProviderDelegate) {
        super(key, modelVersion, parentRef, name, description, objectVersion, inputPorts, outputPorts, objectStatus, identifier, parameters, opConfigValues);
        this.retryAttempts = retryAttempts;
        this.retryDelayUnit = retryDelayUnit;
        this.retryDelay = retryDelay;
        this.expectedDuration = expectedDuration;
        this.expectedDurationUnit = expectedDurationUnit;
        this.taskType = taskType;
        this.task = task;
        this.triggerRule = triggerRule;
        this.configProviderDelegate = configProviderDelegate;
    }

    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public RetryDelayUnit getRetryDelayUnit() {
        return this.retryDelayUnit;
    }

    public Double getRetryDelay() {
        return this.retryDelay;
    }

    public Double getExpectedDuration() {
        return this.expectedDuration;
    }

    public ExpectedDurationUnit getExpectedDurationUnit() {
        return this.expectedDurationUnit;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public Task getTask() {
        return this.task;
    }

    public TriggerRule getTriggerRule() {
        return this.triggerRule;
    }

    public ConfigProvider getConfigProviderDelegate() {
        return this.configProviderDelegate;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskOperator(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", retryAttempts=").append(String.valueOf(this.retryAttempts));
        sb.append(", retryDelayUnit=").append(String.valueOf((Object)this.retryDelayUnit));
        sb.append(", retryDelay=").append(String.valueOf(this.retryDelay));
        sb.append(", expectedDuration=").append(String.valueOf(this.expectedDuration));
        sb.append(", expectedDurationUnit=").append(String.valueOf((Object)this.expectedDurationUnit));
        sb.append(", taskType=").append(String.valueOf((Object)this.taskType));
        sb.append(", task=").append(String.valueOf((Object)this.task));
        sb.append(", triggerRule=").append(String.valueOf((Object)this.triggerRule));
        sb.append(", configProviderDelegate=").append(String.valueOf((Object)this.configProviderDelegate));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskOperator)) {
            return false;
        }
        TaskOperator other = (TaskOperator)((Object)o);
        return Objects.equals(this.retryAttempts, other.retryAttempts) && Objects.equals((Object)this.retryDelayUnit, (Object)other.retryDelayUnit) && Objects.equals(this.retryDelay, other.retryDelay) && Objects.equals(this.expectedDuration, other.expectedDuration) && Objects.equals((Object)this.expectedDurationUnit, (Object)other.expectedDurationUnit) && Objects.equals((Object)this.taskType, (Object)other.taskType) && Objects.equals((Object)this.task, (Object)other.task) && Objects.equals((Object)this.triggerRule, (Object)other.triggerRule) && Objects.equals((Object)this.configProviderDelegate, (Object)other.configProviderDelegate) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.retryAttempts == null ? 43 : this.retryAttempts.hashCode());
        result = result * 59 + (this.retryDelayUnit == null ? 43 : this.retryDelayUnit.hashCode());
        result = result * 59 + (this.retryDelay == null ? 43 : this.retryDelay.hashCode());
        result = result * 59 + (this.expectedDuration == null ? 43 : this.expectedDuration.hashCode());
        result = result * 59 + (this.expectedDurationUnit == null ? 43 : this.expectedDurationUnit.hashCode());
        result = result * 59 + (this.taskType == null ? 43 : this.taskType.hashCode());
        result = result * 59 + (this.task == null ? 43 : this.task.hashCode());
        result = result * 59 + (this.triggerRule == null ? 43 : this.triggerRule.hashCode());
        result = result * 59 + (this.configProviderDelegate == null ? 43 : this.configProviderDelegate.hashCode());
        return result;
    }

    public static enum TriggerRule implements BmcEnum
    {
        AllSuccess("ALL_SUCCESS"),
        AllFailed("ALL_FAILED"),
        AllComplete("ALL_COMPLETE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TriggerRule> map;

        private TriggerRule(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TriggerRule create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TriggerRule', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TriggerRule.class);
            map = new HashMap<String, TriggerRule>();
            for (TriggerRule v : TriggerRule.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TaskType implements BmcEnum
    {
        PipelineTask("PIPELINE_TASK"),
        IntegrationTask("INTEGRATION_TASK"),
        DataLoaderTask("DATA_LOADER_TASK"),
        SqlTask("SQL_TASK"),
        OciDataflowTask("OCI_DATAFLOW_TASK"),
        RestTask("REST_TASK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TaskType> map;

        private TaskType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TaskType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TaskType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TaskType.class);
            map = new HashMap<String, TaskType>();
            for (TaskType v : TaskType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExpectedDurationUnit implements BmcEnum
    {
        Seconds("SECONDS"),
        Minutes("MINUTES"),
        Hours("HOURS"),
        Days("DAYS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExpectedDurationUnit> map;

        private ExpectedDurationUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExpectedDurationUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExpectedDurationUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExpectedDurationUnit.class);
            map = new HashMap<String, ExpectedDurationUnit>();
            for (ExpectedDurationUnit v : ExpectedDurationUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RetryDelayUnit implements BmcEnum
    {
        Seconds("SECONDS"),
        Minutes("MINUTES"),
        Hours("HOURS"),
        Days("DAYS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RetryDelayUnit> map;

        private RetryDelayUnit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RetryDelayUnit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RetryDelayUnit', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RetryDelayUnit.class);
            map = new HashMap<String, RetryDelayUnit>();
            for (RetryDelayUnit v : RetryDelayUnit.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<TypedObject> outputPorts;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="retryAttempts")
        private Integer retryAttempts;
        @JsonProperty(value="retryDelayUnit")
        private RetryDelayUnit retryDelayUnit;
        @JsonProperty(value="retryDelay")
        private Double retryDelay;
        @JsonProperty(value="expectedDuration")
        private Double expectedDuration;
        @JsonProperty(value="expectedDurationUnit")
        private ExpectedDurationUnit expectedDurationUnit;
        @JsonProperty(value="taskType")
        private TaskType taskType;
        @JsonProperty(value="task")
        private Task task;
        @JsonProperty(value="triggerRule")
        private TriggerRule triggerRule;
        @JsonProperty(value="configProviderDelegate")
        private ConfigProvider configProviderDelegate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<TypedObject> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder retryAttempts(Integer retryAttempts) {
            this.retryAttempts = retryAttempts;
            this.__explicitlySet__.add("retryAttempts");
            return this;
        }

        public Builder retryDelayUnit(RetryDelayUnit retryDelayUnit) {
            this.retryDelayUnit = retryDelayUnit;
            this.__explicitlySet__.add("retryDelayUnit");
            return this;
        }

        public Builder retryDelay(Double retryDelay) {
            this.retryDelay = retryDelay;
            this.__explicitlySet__.add("retryDelay");
            return this;
        }

        public Builder expectedDuration(Double expectedDuration) {
            this.expectedDuration = expectedDuration;
            this.__explicitlySet__.add("expectedDuration");
            return this;
        }

        public Builder expectedDurationUnit(ExpectedDurationUnit expectedDurationUnit) {
            this.expectedDurationUnit = expectedDurationUnit;
            this.__explicitlySet__.add("expectedDurationUnit");
            return this;
        }

        public Builder taskType(TaskType taskType) {
            this.taskType = taskType;
            this.__explicitlySet__.add("taskType");
            return this;
        }

        public Builder task(Task task) {
            this.task = task;
            this.__explicitlySet__.add("task");
            return this;
        }

        public Builder triggerRule(TriggerRule triggerRule) {
            this.triggerRule = triggerRule;
            this.__explicitlySet__.add("triggerRule");
            return this;
        }

        public Builder configProviderDelegate(ConfigProvider configProviderDelegate) {
            this.configProviderDelegate = configProviderDelegate;
            this.__explicitlySet__.add("configProviderDelegate");
            return this;
        }

        public TaskOperator build() {
            TaskOperator model = new TaskOperator(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.inputPorts, this.outputPorts, this.objectStatus, this.identifier, this.parameters, this.opConfigValues, this.retryAttempts, this.retryDelayUnit, this.retryDelay, this.expectedDuration, this.expectedDurationUnit, this.taskType, this.task, this.triggerRule, this.configProviderDelegate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TaskOperator model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("inputPorts")) {
                this.inputPorts(model.getInputPorts());
            }
            if (model.wasPropertyExplicitlySet("outputPorts")) {
                this.outputPorts(model.getOutputPorts());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("opConfigValues")) {
                this.opConfigValues(model.getOpConfigValues());
            }
            if (model.wasPropertyExplicitlySet("retryAttempts")) {
                this.retryAttempts(model.getRetryAttempts());
            }
            if (model.wasPropertyExplicitlySet("retryDelayUnit")) {
                this.retryDelayUnit(model.getRetryDelayUnit());
            }
            if (model.wasPropertyExplicitlySet("retryDelay")) {
                this.retryDelay(model.getRetryDelay());
            }
            if (model.wasPropertyExplicitlySet("expectedDuration")) {
                this.expectedDuration(model.getExpectedDuration());
            }
            if (model.wasPropertyExplicitlySet("expectedDurationUnit")) {
                this.expectedDurationUnit(model.getExpectedDurationUnit());
            }
            if (model.wasPropertyExplicitlySet("taskType")) {
                this.taskType(model.getTaskType());
            }
            if (model.wasPropertyExplicitlySet("task")) {
                this.task(model.getTask());
            }
            if (model.wasPropertyExplicitlySet("triggerRule")) {
                this.triggerRule(model.getTriggerRule());
            }
            if (model.wasPropertyExplicitlySet("configProviderDelegate")) {
                this.configProviderDelegate(model.getConfigProviderDelegate());
            }
            return this;
        }
    }
}

