/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.BaseType;
import com.oracle.bmc.dataintegration.model.ConfigDefinition;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StructuredType
extends ExplicitlySetBmcModel {
    @JsonProperty(value="schema")
    private final BaseType schema;
    @JsonProperty(value="dtType")
    private final DtType dtType;
    @JsonProperty(value="typeSystemName")
    private final String typeSystemName;
    @JsonProperty(value="configDefinition")
    private final ConfigDefinition configDefinition;

    @Deprecated
    @ConstructorProperties(value={"schema", "dtType", "typeSystemName", "configDefinition"})
    public StructuredType(BaseType schema, DtType dtType, String typeSystemName, ConfigDefinition configDefinition) {
        this.schema = schema;
        this.dtType = dtType;
        this.typeSystemName = typeSystemName;
        this.configDefinition = configDefinition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BaseType getSchema() {
        return this.schema;
    }

    public DtType getDtType() {
        return this.dtType;
    }

    public String getTypeSystemName() {
        return this.typeSystemName;
    }

    public ConfigDefinition getConfigDefinition() {
        return this.configDefinition;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StructuredType(");
        sb.append("super=").append(super.toString());
        sb.append("schema=").append(String.valueOf((Object)this.schema));
        sb.append(", dtType=").append(String.valueOf((Object)this.dtType));
        sb.append(", typeSystemName=").append(String.valueOf(this.typeSystemName));
        sb.append(", configDefinition=").append(String.valueOf((Object)this.configDefinition));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructuredType)) {
            return false;
        }
        StructuredType other = (StructuredType)((Object)o);
        return Objects.equals((Object)this.schema, (Object)other.schema) && Objects.equals((Object)this.dtType, (Object)other.dtType) && Objects.equals(this.typeSystemName, other.typeSystemName) && Objects.equals((Object)this.configDefinition, (Object)other.configDefinition) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.schema == null ? 43 : this.schema.hashCode());
        result = result * 59 + (this.dtType == null ? 43 : this.dtType.hashCode());
        result = result * 59 + (this.typeSystemName == null ? 43 : this.typeSystemName.hashCode());
        result = result * 59 + (this.configDefinition == null ? 43 : this.configDefinition.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DtType implements BmcEnum
    {
        Primitive("PRIMITIVE"),
        Structured("STRUCTURED");

        private final String value;
        private static Map<String, DtType> map;

        private DtType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DtType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DtType: " + key);
        }

        static {
            map = new HashMap<String, DtType>();
            for (DtType v : DtType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="schema")
        private BaseType schema;
        @JsonProperty(value="dtType")
        private DtType dtType;
        @JsonProperty(value="typeSystemName")
        private String typeSystemName;
        @JsonProperty(value="configDefinition")
        private ConfigDefinition configDefinition;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder schema(BaseType schema) {
            this.schema = schema;
            this.__explicitlySet__.add("schema");
            return this;
        }

        public Builder dtType(DtType dtType) {
            this.dtType = dtType;
            this.__explicitlySet__.add("dtType");
            return this;
        }

        public Builder typeSystemName(String typeSystemName) {
            this.typeSystemName = typeSystemName;
            this.__explicitlySet__.add("typeSystemName");
            return this;
        }

        public Builder configDefinition(ConfigDefinition configDefinition) {
            this.configDefinition = configDefinition;
            this.__explicitlySet__.add("configDefinition");
            return this;
        }

        public StructuredType build() {
            StructuredType model = new StructuredType(this.schema, this.dtType, this.typeSystemName, this.configDefinition);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StructuredType model) {
            if (model.wasPropertyExplicitlySet("schema")) {
                this.schema(model.getSchema());
            }
            if (model.wasPropertyExplicitlySet("dtType")) {
                this.dtType(model.getDtType());
            }
            if (model.wasPropertyExplicitlySet("typeSystemName")) {
                this.typeSystemName(model.getTypeSystemName());
            }
            if (model.wasPropertyExplicitlySet("configDefinition")) {
                this.configDefinition(model.getConfigDefinition());
            }
            return this;
        }
    }
}

