/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SchemaDriftConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="extraColumnHandling")
    private final ExtraColumnHandling extraColumnHandling;
    @JsonProperty(value="missingColumnHandling")
    private final MissingColumnHandling missingColumnHandling;
    @JsonProperty(value="dataTypeChangeHandling")
    private final DataTypeChangeHandling dataTypeChangeHandling;
    @JsonProperty(value="isValidationWarningIfAllowed")
    private final Boolean isValidationWarningIfAllowed;

    @Deprecated
    @ConstructorProperties(value={"extraColumnHandling", "missingColumnHandling", "dataTypeChangeHandling", "isValidationWarningIfAllowed"})
    public SchemaDriftConfig(ExtraColumnHandling extraColumnHandling, MissingColumnHandling missingColumnHandling, DataTypeChangeHandling dataTypeChangeHandling, Boolean isValidationWarningIfAllowed) {
        this.extraColumnHandling = extraColumnHandling;
        this.missingColumnHandling = missingColumnHandling;
        this.dataTypeChangeHandling = dataTypeChangeHandling;
        this.isValidationWarningIfAllowed = isValidationWarningIfAllowed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ExtraColumnHandling getExtraColumnHandling() {
        return this.extraColumnHandling;
    }

    public MissingColumnHandling getMissingColumnHandling() {
        return this.missingColumnHandling;
    }

    public DataTypeChangeHandling getDataTypeChangeHandling() {
        return this.dataTypeChangeHandling;
    }

    public Boolean getIsValidationWarningIfAllowed() {
        return this.isValidationWarningIfAllowed;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SchemaDriftConfig(");
        sb.append("super=").append(super.toString());
        sb.append("extraColumnHandling=").append(String.valueOf((Object)this.extraColumnHandling));
        sb.append(", missingColumnHandling=").append(String.valueOf((Object)this.missingColumnHandling));
        sb.append(", dataTypeChangeHandling=").append(String.valueOf((Object)this.dataTypeChangeHandling));
        sb.append(", isValidationWarningIfAllowed=").append(String.valueOf(this.isValidationWarningIfAllowed));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaDriftConfig)) {
            return false;
        }
        SchemaDriftConfig other = (SchemaDriftConfig)((Object)o);
        return Objects.equals((Object)this.extraColumnHandling, (Object)other.extraColumnHandling) && Objects.equals((Object)this.missingColumnHandling, (Object)other.missingColumnHandling) && Objects.equals((Object)this.dataTypeChangeHandling, (Object)other.dataTypeChangeHandling) && Objects.equals(this.isValidationWarningIfAllowed, other.isValidationWarningIfAllowed) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.extraColumnHandling == null ? 43 : this.extraColumnHandling.hashCode());
        result = result * 59 + (this.missingColumnHandling == null ? 43 : this.missingColumnHandling.hashCode());
        result = result * 59 + (this.dataTypeChangeHandling == null ? 43 : this.dataTypeChangeHandling.hashCode());
        result = result * 59 + (this.isValidationWarningIfAllowed == null ? 43 : this.isValidationWarningIfAllowed.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DataTypeChangeHandling implements BmcEnum
    {
        Allow("ALLOW"),
        DoCastIfPossible("DO_CAST_IF_POSSIBLE"),
        DoNotAllow("DO_NOT_ALLOW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DataTypeChangeHandling> map;

        private DataTypeChangeHandling(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DataTypeChangeHandling create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DataTypeChangeHandling', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DataTypeChangeHandling.class);
            map = new HashMap<String, DataTypeChangeHandling>();
            for (DataTypeChangeHandling v : DataTypeChangeHandling.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum MissingColumnHandling implements BmcEnum
    {
        Allow("ALLOW"),
        NullSelect("NULL_SELECT"),
        DoNotAllow("DO_NOT_ALLOW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MissingColumnHandling> map;

        private MissingColumnHandling(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MissingColumnHandling create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MissingColumnHandling', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MissingColumnHandling.class);
            map = new HashMap<String, MissingColumnHandling>();
            for (MissingColumnHandling v : MissingColumnHandling.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ExtraColumnHandling implements BmcEnum
    {
        Allow("ALLOW"),
        NullFillup("NULL_FILLUP"),
        DoNotAllow("DO_NOT_ALLOW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExtraColumnHandling> map;

        private ExtraColumnHandling(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExtraColumnHandling create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExtraColumnHandling', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExtraColumnHandling.class);
            map = new HashMap<String, ExtraColumnHandling>();
            for (ExtraColumnHandling v : ExtraColumnHandling.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="extraColumnHandling")
        private ExtraColumnHandling extraColumnHandling;
        @JsonProperty(value="missingColumnHandling")
        private MissingColumnHandling missingColumnHandling;
        @JsonProperty(value="dataTypeChangeHandling")
        private DataTypeChangeHandling dataTypeChangeHandling;
        @JsonProperty(value="isValidationWarningIfAllowed")
        private Boolean isValidationWarningIfAllowed;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder extraColumnHandling(ExtraColumnHandling extraColumnHandling) {
            this.extraColumnHandling = extraColumnHandling;
            this.__explicitlySet__.add("extraColumnHandling");
            return this;
        }

        public Builder missingColumnHandling(MissingColumnHandling missingColumnHandling) {
            this.missingColumnHandling = missingColumnHandling;
            this.__explicitlySet__.add("missingColumnHandling");
            return this;
        }

        public Builder dataTypeChangeHandling(DataTypeChangeHandling dataTypeChangeHandling) {
            this.dataTypeChangeHandling = dataTypeChangeHandling;
            this.__explicitlySet__.add("dataTypeChangeHandling");
            return this;
        }

        public Builder isValidationWarningIfAllowed(Boolean isValidationWarningIfAllowed) {
            this.isValidationWarningIfAllowed = isValidationWarningIfAllowed;
            this.__explicitlySet__.add("isValidationWarningIfAllowed");
            return this;
        }

        public SchemaDriftConfig build() {
            SchemaDriftConfig model = new SchemaDriftConfig(this.extraColumnHandling, this.missingColumnHandling, this.dataTypeChangeHandling, this.isValidationWarningIfAllowed);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SchemaDriftConfig model) {
            if (model.wasPropertyExplicitlySet("extraColumnHandling")) {
                this.extraColumnHandling(model.getExtraColumnHandling());
            }
            if (model.wasPropertyExplicitlySet("missingColumnHandling")) {
                this.missingColumnHandling(model.getMissingColumnHandling());
            }
            if (model.wasPropertyExplicitlySet("dataTypeChangeHandling")) {
                this.dataTypeChangeHandling(model.getDataTypeChangeHandling());
            }
            if (model.wasPropertyExplicitlySet("isValidationWarningIfAllowed")) {
                this.isValidationWarningIfAllowed(model.getIsValidationWarningIfAllowed());
            }
            return this;
        }
    }
}

