/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.FieldMap;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class RuleBasedEntityMap
extends FieldMap {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;
    @JsonProperty(value="mapType")
    private final MapType mapType;
    @JsonProperty(value="fromPattern")
    private final String fromPattern;
    @JsonProperty(value="toPattern")
    private final String toPattern;
    @JsonProperty(value="isJavaRegexSyntax")
    private final Boolean isJavaRegexSyntax;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RuleBasedEntityMap(String description, String key, String modelVersion, ParentReference parentRef, ConfigValues configValues, MapType mapType, String fromPattern, String toPattern, Boolean isJavaRegexSyntax, Integer objectStatus) {
        super(description);
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.configValues = configValues;
        this.mapType = mapType;
        this.fromPattern = fromPattern;
        this.toPattern = toPattern;
        this.isJavaRegexSyntax = isJavaRegexSyntax;
        this.objectStatus = objectStatus;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public String getFromPattern() {
        return this.fromPattern;
    }

    public String getToPattern() {
        return this.toPattern;
    }

    public Boolean getIsJavaRegexSyntax() {
        return this.isJavaRegexSyntax;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RuleBasedEntityMap(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(", mapType=").append(String.valueOf((Object)this.mapType));
        sb.append(", fromPattern=").append(String.valueOf(this.fromPattern));
        sb.append(", toPattern=").append(String.valueOf(this.toPattern));
        sb.append(", isJavaRegexSyntax=").append(String.valueOf(this.isJavaRegexSyntax));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuleBasedEntityMap)) {
            return false;
        }
        RuleBasedEntityMap other = (RuleBasedEntityMap)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals((Object)this.configValues, (Object)other.configValues) && Objects.equals((Object)this.mapType, (Object)other.mapType) && Objects.equals(this.fromPattern, other.fromPattern) && Objects.equals(this.toPattern, other.toPattern) && Objects.equals(this.isJavaRegexSyntax, other.isJavaRegexSyntax) && Objects.equals(this.objectStatus, other.objectStatus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + (this.mapType == null ? 43 : this.mapType.hashCode());
        result = result * 59 + (this.fromPattern == null ? 43 : this.fromPattern.hashCode());
        result = result * 59 + (this.toPattern == null ? 43 : this.toPattern.hashCode());
        result = result * 59 + (this.isJavaRegexSyntax == null ? 43 : this.isJavaRegexSyntax.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        return result;
    }

    public static enum MapType implements BmcEnum
    {
        Mapbyname("MAPBYNAME"),
        Mapbypattern("MAPBYPATTERN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MapType> map;

        private MapType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MapType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MapType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MapType.class);
            map = new HashMap<String, MapType>();
            for (MapType v : MapType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="mapType")
        private MapType mapType;
        @JsonProperty(value="fromPattern")
        private String fromPattern;
        @JsonProperty(value="toPattern")
        private String toPattern;
        @JsonProperty(value="isJavaRegexSyntax")
        private Boolean isJavaRegexSyntax;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder mapType(MapType mapType) {
            this.mapType = mapType;
            this.__explicitlySet__.add("mapType");
            return this;
        }

        public Builder fromPattern(String fromPattern) {
            this.fromPattern = fromPattern;
            this.__explicitlySet__.add("fromPattern");
            return this;
        }

        public Builder toPattern(String toPattern) {
            this.toPattern = toPattern;
            this.__explicitlySet__.add("toPattern");
            return this;
        }

        public Builder isJavaRegexSyntax(Boolean isJavaRegexSyntax) {
            this.isJavaRegexSyntax = isJavaRegexSyntax;
            this.__explicitlySet__.add("isJavaRegexSyntax");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public RuleBasedEntityMap build() {
            RuleBasedEntityMap model = new RuleBasedEntityMap(this.description, this.key, this.modelVersion, this.parentRef, this.configValues, this.mapType, this.fromPattern, this.toPattern, this.isJavaRegexSyntax, this.objectStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RuleBasedEntityMap model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            if (model.wasPropertyExplicitlySet("mapType")) {
                this.mapType(model.getMapType());
            }
            if (model.wasPropertyExplicitlySet("fromPattern")) {
                this.fromPattern(model.getFromPattern());
            }
            if (model.wasPropertyExplicitlySet("toPattern")) {
                this.toPattern(model.getToPattern());
            }
            if (model.wasPropertyExplicitlySet("isJavaRegexSyntax")) {
                this.isJavaRegexSyntax(model.getIsJavaRegexSyntax());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            return this;
        }
    }
}

