/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AuthConfig;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class ResourcePrincipalAuthConfig
extends AuthConfig {
    @JsonProperty(value="resourcePrincipalSource")
    private final ResourcePrincipalSource resourcePrincipalSource;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ResourcePrincipalAuthConfig(String key, String modelVersion, ParentReference parentRef, ResourcePrincipalSource resourcePrincipalSource) {
        super(key, modelVersion, parentRef);
        this.resourcePrincipalSource = resourcePrincipalSource;
    }

    public ResourcePrincipalSource getResourcePrincipalSource() {
        return this.resourcePrincipalSource;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourcePrincipalAuthConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", resourcePrincipalSource=").append(String.valueOf((Object)this.resourcePrincipalSource));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourcePrincipalAuthConfig)) {
            return false;
        }
        ResourcePrincipalAuthConfig other = (ResourcePrincipalAuthConfig)((Object)o);
        return Objects.equals((Object)this.resourcePrincipalSource, (Object)other.resourcePrincipalSource) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.resourcePrincipalSource == null ? 43 : this.resourcePrincipalSource.hashCode());
        return result;
    }

    public static enum ResourcePrincipalSource implements BmcEnum
    {
        Workspace("WORKSPACE"),
        Application("APPLICATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourcePrincipalSource> map;

        private ResourcePrincipalSource(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourcePrincipalSource create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourcePrincipalSource', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourcePrincipalSource.class);
            map = new HashMap<String, ResourcePrincipalSource>();
            for (ResourcePrincipalSource v : ResourcePrincipalSource.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="resourcePrincipalSource")
        private ResourcePrincipalSource resourcePrincipalSource;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder resourcePrincipalSource(ResourcePrincipalSource resourcePrincipalSource) {
            this.resourcePrincipalSource = resourcePrincipalSource;
            this.__explicitlySet__.add("resourcePrincipalSource");
            return this;
        }

        public ResourcePrincipalAuthConfig build() {
            ResourcePrincipalAuthConfig model = new ResourcePrincipalAuthConfig(this.key, this.modelVersion, this.parentRef, this.resourcePrincipalSource);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourcePrincipalAuthConfig model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("resourcePrincipalSource")) {
                this.resourcePrincipalSource(model.getResourcePrincipalSource());
            }
            return this;
        }
    }
}

