/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.ProjectionRule;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class RenameRule
extends ProjectionRule {
    @JsonProperty(value="isSkipRemainingRulesOnMatch")
    private final Boolean isSkipRemainingRulesOnMatch;
    @JsonProperty(value="fromName")
    private final String fromName;
    @JsonProperty(value="toName")
    private final String toName;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RenameRule(String key, String modelVersion, ParentReference parentRef, Boolean isJavaRegexSyntax, ConfigValues configValues, Integer objectStatus, String description, Boolean isSkipRemainingRulesOnMatch, String fromName, String toName) {
        super(key, modelVersion, parentRef, isJavaRegexSyntax, configValues, objectStatus, description);
        this.isSkipRemainingRulesOnMatch = isSkipRemainingRulesOnMatch;
        this.fromName = fromName;
        this.toName = toName;
    }

    public Boolean getIsSkipRemainingRulesOnMatch() {
        return this.isSkipRemainingRulesOnMatch;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getToName() {
        return this.toName;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RenameRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", isSkipRemainingRulesOnMatch=").append(String.valueOf(this.isSkipRemainingRulesOnMatch));
        sb.append(", fromName=").append(String.valueOf(this.fromName));
        sb.append(", toName=").append(String.valueOf(this.toName));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenameRule)) {
            return false;
        }
        RenameRule other = (RenameRule)((Object)o);
        return Objects.equals(this.isSkipRemainingRulesOnMatch, other.isSkipRemainingRulesOnMatch) && Objects.equals(this.fromName, other.fromName) && Objects.equals(this.toName, other.toName) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSkipRemainingRulesOnMatch == null ? 43 : this.isSkipRemainingRulesOnMatch.hashCode());
        result = result * 59 + (this.fromName == null ? 43 : this.fromName.hashCode());
        result = result * 59 + (this.toName == null ? 43 : this.toName.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="isJavaRegexSyntax")
        private Boolean isJavaRegexSyntax;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="isSkipRemainingRulesOnMatch")
        private Boolean isSkipRemainingRulesOnMatch;
        @JsonProperty(value="fromName")
        private String fromName;
        @JsonProperty(value="toName")
        private String toName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder isJavaRegexSyntax(Boolean isJavaRegexSyntax) {
            this.isJavaRegexSyntax = isJavaRegexSyntax;
            this.__explicitlySet__.add("isJavaRegexSyntax");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder isSkipRemainingRulesOnMatch(Boolean isSkipRemainingRulesOnMatch) {
            this.isSkipRemainingRulesOnMatch = isSkipRemainingRulesOnMatch;
            this.__explicitlySet__.add("isSkipRemainingRulesOnMatch");
            return this;
        }

        public Builder fromName(String fromName) {
            this.fromName = fromName;
            this.__explicitlySet__.add("fromName");
            return this;
        }

        public Builder toName(String toName) {
            this.toName = toName;
            this.__explicitlySet__.add("toName");
            return this;
        }

        public RenameRule build() {
            RenameRule model = new RenameRule(this.key, this.modelVersion, this.parentRef, this.isJavaRegexSyntax, this.configValues, this.objectStatus, this.description, this.isSkipRemainingRulesOnMatch, this.fromName, this.toName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RenameRule model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("isJavaRegexSyntax")) {
                this.isJavaRegexSyntax(model.getIsJavaRegexSyntax());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("isSkipRemainingRulesOnMatch")) {
                this.isSkipRemainingRulesOnMatch(model.getIsSkipRemainingRulesOnMatch());
            }
            if (model.wasPropertyExplicitlySet("fromName")) {
                this.fromName(model.getFromName());
            }
            if (model.wasPropertyExplicitlySet("toName")) {
                this.toName(model.getToName());
            }
            return this;
        }
    }
}

