/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PivotKeys
extends ExplicitlySetBmcModel {
    @JsonProperty(value="pivotAxis")
    private final List<String> pivotAxis;
    @JsonProperty(value="pivotKeyValueMap")
    private final Map<String, List<String>> pivotKeyValueMap;
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;

    @Deprecated
    @ConstructorProperties(value={"pivotAxis", "pivotKeyValueMap", "key", "modelType", "modelVersion", "parentRef", "objectStatus"})
    public PivotKeys(List<String> pivotAxis, Map<String, List<String>> pivotKeyValueMap, String key, String modelType, String modelVersion, ParentReference parentRef, Integer objectStatus) {
        this.pivotAxis = pivotAxis;
        this.pivotKeyValueMap = pivotKeyValueMap;
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.objectStatus = objectStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getPivotAxis() {
        return this.pivotAxis;
    }

    public Map<String, List<String>> getPivotKeyValueMap() {
        return this.pivotKeyValueMap;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PivotKeys(");
        sb.append("super=").append(super.toString());
        sb.append("pivotAxis=").append(String.valueOf(this.pivotAxis));
        sb.append(", pivotKeyValueMap=").append(String.valueOf(this.pivotKeyValueMap));
        sb.append(", key=").append(String.valueOf(this.key));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PivotKeys)) {
            return false;
        }
        PivotKeys other = (PivotKeys)((Object)o);
        return Objects.equals(this.pivotAxis, other.pivotAxis) && Objects.equals(this.pivotKeyValueMap, other.pivotKeyValueMap) && Objects.equals(this.key, other.key) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.objectStatus, other.objectStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.pivotAxis == null ? 43 : this.pivotAxis.hashCode());
        result = result * 59 + (this.pivotKeyValueMap == null ? 43 : this.pivotKeyValueMap.hashCode());
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="pivotAxis")
        private List<String> pivotAxis;
        @JsonProperty(value="pivotKeyValueMap")
        private Map<String, List<String>> pivotKeyValueMap;
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder pivotAxis(List<String> pivotAxis) {
            this.pivotAxis = pivotAxis;
            this.__explicitlySet__.add("pivotAxis");
            return this;
        }

        public Builder pivotKeyValueMap(Map<String, List<String>> pivotKeyValueMap) {
            this.pivotKeyValueMap = pivotKeyValueMap;
            this.__explicitlySet__.add("pivotKeyValueMap");
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public PivotKeys build() {
            PivotKeys model = new PivotKeys(this.pivotAxis, this.pivotKeyValueMap, this.key, this.modelType, this.modelVersion, this.parentRef, this.objectStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PivotKeys model) {
            if (model.wasPropertyExplicitlySet("pivotAxis")) {
                this.pivotAxis(model.getPivotAxis());
            }
            if (model.wasPropertyExplicitlySet("pivotKeyValueMap")) {
                this.pivotKeyValueMap(model.getPivotKeyValueMap());
            }
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            return this;
        }
    }
}

