/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractWriteAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class OracleWriteAttributes
extends AbstractWriteAttribute {
    @JsonProperty(value="batchSize")
    private final Integer batchSize;
    @JsonProperty(value="isTruncate")
    private final Boolean isTruncate;
    @JsonProperty(value="isolationLevel")
    private final String isolationLevel;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OracleWriteAttributes(Integer batchSize, Boolean isTruncate, String isolationLevel) {
        this.batchSize = batchSize;
        this.isTruncate = isTruncate;
        this.isolationLevel = isolationLevel;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Boolean getIsTruncate() {
        return this.isTruncate;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OracleWriteAttributes(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", batchSize=").append(String.valueOf(this.batchSize));
        sb.append(", isTruncate=").append(String.valueOf(this.isTruncate));
        sb.append(", isolationLevel=").append(String.valueOf(this.isolationLevel));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OracleWriteAttributes)) {
            return false;
        }
        OracleWriteAttributes other = (OracleWriteAttributes)((Object)o);
        return Objects.equals(this.batchSize, other.batchSize) && Objects.equals(this.isTruncate, other.isTruncate) && Objects.equals(this.isolationLevel, other.isolationLevel) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.batchSize == null ? 43 : this.batchSize.hashCode());
        result = result * 59 + (this.isTruncate == null ? 43 : this.isTruncate.hashCode());
        result = result * 59 + (this.isolationLevel == null ? 43 : this.isolationLevel.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="batchSize")
        private Integer batchSize;
        @JsonProperty(value="isTruncate")
        private Boolean isTruncate;
        @JsonProperty(value="isolationLevel")
        private String isolationLevel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            this.__explicitlySet__.add("batchSize");
            return this;
        }

        public Builder isTruncate(Boolean isTruncate) {
            this.isTruncate = isTruncate;
            this.__explicitlySet__.add("isTruncate");
            return this;
        }

        public Builder isolationLevel(String isolationLevel) {
            this.isolationLevel = isolationLevel;
            this.__explicitlySet__.add("isolationLevel");
            return this;
        }

        public OracleWriteAttributes build() {
            OracleWriteAttributes model = new OracleWriteAttributes(this.batchSize, this.isTruncate, this.isolationLevel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OracleWriteAttributes model) {
            if (model.wasPropertyExplicitlySet("batchSize")) {
                this.batchSize(model.getBatchSize());
            }
            if (model.wasPropertyExplicitlySet("isTruncate")) {
                this.isTruncate(model.getIsTruncate());
            }
            if (model.wasPropertyExplicitlySet("isolationLevel")) {
                this.isolationLevel(model.getIsolationLevel());
            }
            return this;
        }
    }
}

