/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractWriteAttribute;
import com.oracle.bmc.dataintegration.model.Connection;
import com.oracle.bmc.dataintegration.model.DataAsset;
import com.oracle.bmc.dataintegration.model.Schema;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class OracleAtpWriteAttributes
extends AbstractWriteAttribute {
    @JsonProperty(value="bucketSchema")
    private final Schema bucketSchema;
    @JsonProperty(value="stagingFileName")
    private final String stagingFileName;
    @JsonProperty(value="stagingDataAsset")
    private final DataAsset stagingDataAsset;
    @JsonProperty(value="stagingConnection")
    private final Connection stagingConnection;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OracleAtpWriteAttributes(Schema bucketSchema, String stagingFileName, DataAsset stagingDataAsset, Connection stagingConnection) {
        this.bucketSchema = bucketSchema;
        this.stagingFileName = stagingFileName;
        this.stagingDataAsset = stagingDataAsset;
        this.stagingConnection = stagingConnection;
    }

    public Schema getBucketSchema() {
        return this.bucketSchema;
    }

    public String getStagingFileName() {
        return this.stagingFileName;
    }

    public DataAsset getStagingDataAsset() {
        return this.stagingDataAsset;
    }

    public Connection getStagingConnection() {
        return this.stagingConnection;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OracleAtpWriteAttributes(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", bucketSchema=").append(String.valueOf((Object)this.bucketSchema));
        sb.append(", stagingFileName=").append(String.valueOf(this.stagingFileName));
        sb.append(", stagingDataAsset=").append(String.valueOf((Object)this.stagingDataAsset));
        sb.append(", stagingConnection=").append(String.valueOf((Object)this.stagingConnection));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OracleAtpWriteAttributes)) {
            return false;
        }
        OracleAtpWriteAttributes other = (OracleAtpWriteAttributes)((Object)o);
        return Objects.equals((Object)this.bucketSchema, (Object)other.bucketSchema) && Objects.equals(this.stagingFileName, other.stagingFileName) && Objects.equals((Object)this.stagingDataAsset, (Object)other.stagingDataAsset) && Objects.equals((Object)this.stagingConnection, (Object)other.stagingConnection) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bucketSchema == null ? 43 : this.bucketSchema.hashCode());
        result = result * 59 + (this.stagingFileName == null ? 43 : this.stagingFileName.hashCode());
        result = result * 59 + (this.stagingDataAsset == null ? 43 : this.stagingDataAsset.hashCode());
        result = result * 59 + (this.stagingConnection == null ? 43 : this.stagingConnection.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bucketSchema")
        private Schema bucketSchema;
        @JsonProperty(value="stagingFileName")
        private String stagingFileName;
        @JsonProperty(value="stagingDataAsset")
        private DataAsset stagingDataAsset;
        @JsonProperty(value="stagingConnection")
        private Connection stagingConnection;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bucketSchema(Schema bucketSchema) {
            this.bucketSchema = bucketSchema;
            this.__explicitlySet__.add("bucketSchema");
            return this;
        }

        public Builder stagingFileName(String stagingFileName) {
            this.stagingFileName = stagingFileName;
            this.__explicitlySet__.add("stagingFileName");
            return this;
        }

        public Builder stagingDataAsset(DataAsset stagingDataAsset) {
            this.stagingDataAsset = stagingDataAsset;
            this.__explicitlySet__.add("stagingDataAsset");
            return this;
        }

        public Builder stagingConnection(Connection stagingConnection) {
            this.stagingConnection = stagingConnection;
            this.__explicitlySet__.add("stagingConnection");
            return this;
        }

        public OracleAtpWriteAttributes build() {
            OracleAtpWriteAttributes model = new OracleAtpWriteAttributes(this.bucketSchema, this.stagingFileName, this.stagingDataAsset, this.stagingConnection);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OracleAtpWriteAttributes model) {
            if (model.wasPropertyExplicitlySet("bucketSchema")) {
                this.bucketSchema(model.getBucketSchema());
            }
            if (model.wasPropertyExplicitlySet("stagingFileName")) {
                this.stagingFileName(model.getStagingFileName());
            }
            if (model.wasPropertyExplicitlySet("stagingDataAsset")) {
                this.stagingDataAsset(model.getStagingDataAsset());
            }
            if (model.wasPropertyExplicitlySet("stagingConnection")) {
                this.stagingConnection(model.getStagingConnection());
            }
            return this;
        }
    }
}

