/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.Expression;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.Operator;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypedObject;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class Lookup
extends Operator {
    @JsonProperty(value="lookupCondition")
    private final Expression lookupCondition;
    @JsonProperty(value="isSkipNoMatch")
    private final Boolean isSkipNoMatch;
    @JsonProperty(value="multiMatchStrategy")
    private final MultiMatchStrategy multiMatchStrategy;
    @JsonProperty(value="nullFillValues")
    private final Map<String, Object> nullFillValues;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public Lookup(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, List<InputPort> inputPorts, List<TypedObject> outputPorts, Integer objectStatus, String identifier, List<Parameter> parameters, ConfigValues opConfigValues, Expression lookupCondition, Boolean isSkipNoMatch, MultiMatchStrategy multiMatchStrategy, Map<String, Object> nullFillValues) {
        super(key, modelVersion, parentRef, name, description, objectVersion, inputPorts, outputPorts, objectStatus, identifier, parameters, opConfigValues);
        this.lookupCondition = lookupCondition;
        this.isSkipNoMatch = isSkipNoMatch;
        this.multiMatchStrategy = multiMatchStrategy;
        this.nullFillValues = nullFillValues;
    }

    public Expression getLookupCondition() {
        return this.lookupCondition;
    }

    public Boolean getIsSkipNoMatch() {
        return this.isSkipNoMatch;
    }

    public MultiMatchStrategy getMultiMatchStrategy() {
        return this.multiMatchStrategy;
    }

    public Map<String, Object> getNullFillValues() {
        return this.nullFillValues;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Lookup(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", lookupCondition=").append(String.valueOf((Object)this.lookupCondition));
        sb.append(", isSkipNoMatch=").append(String.valueOf(this.isSkipNoMatch));
        sb.append(", multiMatchStrategy=").append(String.valueOf((Object)this.multiMatchStrategy));
        sb.append(", nullFillValues=").append(String.valueOf(this.nullFillValues));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Lookup)) {
            return false;
        }
        Lookup other = (Lookup)((Object)o);
        return Objects.equals((Object)this.lookupCondition, (Object)other.lookupCondition) && Objects.equals(this.isSkipNoMatch, other.isSkipNoMatch) && Objects.equals((Object)this.multiMatchStrategy, (Object)other.multiMatchStrategy) && Objects.equals(this.nullFillValues, other.nullFillValues) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.lookupCondition == null ? 43 : this.lookupCondition.hashCode());
        result = result * 59 + (this.isSkipNoMatch == null ? 43 : this.isSkipNoMatch.hashCode());
        result = result * 59 + (this.multiMatchStrategy == null ? 43 : this.multiMatchStrategy.hashCode());
        result = result * 59 + (this.nullFillValues == null ? 43 : this.nullFillValues.hashCode());
        return result;
    }

    public static enum MultiMatchStrategy implements BmcEnum
    {
        ReturnAny("RETURN_ANY"),
        ReturnFirst("RETURN_FIRST"),
        ReturnLast("RETURN_LAST"),
        ReturnAll("RETURN_ALL"),
        ReturnError("RETURN_ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MultiMatchStrategy> map;

        private MultiMatchStrategy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MultiMatchStrategy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MultiMatchStrategy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MultiMatchStrategy.class);
            map = new HashMap<String, MultiMatchStrategy>();
            for (MultiMatchStrategy v : MultiMatchStrategy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<TypedObject> outputPorts;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="lookupCondition")
        private Expression lookupCondition;
        @JsonProperty(value="isSkipNoMatch")
        private Boolean isSkipNoMatch;
        @JsonProperty(value="multiMatchStrategy")
        private MultiMatchStrategy multiMatchStrategy;
        @JsonProperty(value="nullFillValues")
        private Map<String, Object> nullFillValues;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<TypedObject> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder lookupCondition(Expression lookupCondition) {
            this.lookupCondition = lookupCondition;
            this.__explicitlySet__.add("lookupCondition");
            return this;
        }

        public Builder isSkipNoMatch(Boolean isSkipNoMatch) {
            this.isSkipNoMatch = isSkipNoMatch;
            this.__explicitlySet__.add("isSkipNoMatch");
            return this;
        }

        public Builder multiMatchStrategy(MultiMatchStrategy multiMatchStrategy) {
            this.multiMatchStrategy = multiMatchStrategy;
            this.__explicitlySet__.add("multiMatchStrategy");
            return this;
        }

        public Builder nullFillValues(Map<String, Object> nullFillValues) {
            this.nullFillValues = nullFillValues;
            this.__explicitlySet__.add("nullFillValues");
            return this;
        }

        public Lookup build() {
            Lookup model = new Lookup(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.inputPorts, this.outputPorts, this.objectStatus, this.identifier, this.parameters, this.opConfigValues, this.lookupCondition, this.isSkipNoMatch, this.multiMatchStrategy, this.nullFillValues);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Lookup model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("inputPorts")) {
                this.inputPorts(model.getInputPorts());
            }
            if (model.wasPropertyExplicitlySet("outputPorts")) {
                this.outputPorts(model.getOutputPorts());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("opConfigValues")) {
                this.opConfigValues(model.getOpConfigValues());
            }
            if (model.wasPropertyExplicitlySet("lookupCondition")) {
                this.lookupCondition(model.getLookupCondition());
            }
            if (model.wasPropertyExplicitlySet("isSkipNoMatch")) {
                this.isSkipNoMatch(model.getIsSkipNoMatch());
            }
            if (model.wasPropertyExplicitlySet("multiMatchStrategy")) {
                this.multiMatchStrategy(model.getMultiMatchStrategy());
            }
            if (model.wasPropertyExplicitlySet("nullFillValues")) {
                this.nullFillValues(model.getNullFillValues());
            }
            return this;
        }
    }
}

