/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.dataintegration.model.DynamicProxyField;
import com.oracle.bmc.dataintegration.model.FlattenDetails;
import com.oracle.bmc.dataintegration.model.InputPort;
import com.oracle.bmc.dataintegration.model.MaterializedDynamicField;
import com.oracle.bmc.dataintegration.model.Operator;
import com.oracle.bmc.dataintegration.model.Parameter;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.TypedObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class Flatten
extends Operator {
    @JsonProperty(value="flattenDetails")
    private final FlattenDetails flattenDetails;
    @JsonProperty(value="flattenField")
    private final DynamicProxyField flattenField;
    @JsonProperty(value="materializedFlattenField")
    private final MaterializedDynamicField materializedFlattenField;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public Flatten(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, List<InputPort> inputPorts, List<TypedObject> outputPorts, Integer objectStatus, String identifier, List<Parameter> parameters, ConfigValues opConfigValues, FlattenDetails flattenDetails, DynamicProxyField flattenField, MaterializedDynamicField materializedFlattenField) {
        super(key, modelVersion, parentRef, name, description, objectVersion, inputPorts, outputPorts, objectStatus, identifier, parameters, opConfigValues);
        this.flattenDetails = flattenDetails;
        this.flattenField = flattenField;
        this.materializedFlattenField = materializedFlattenField;
    }

    public FlattenDetails getFlattenDetails() {
        return this.flattenDetails;
    }

    public DynamicProxyField getFlattenField() {
        return this.flattenField;
    }

    public MaterializedDynamicField getMaterializedFlattenField() {
        return this.materializedFlattenField;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Flatten(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", flattenDetails=").append(String.valueOf((Object)this.flattenDetails));
        sb.append(", flattenField=").append(String.valueOf((Object)this.flattenField));
        sb.append(", materializedFlattenField=").append(String.valueOf((Object)this.materializedFlattenField));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Flatten)) {
            return false;
        }
        Flatten other = (Flatten)((Object)o);
        return Objects.equals((Object)this.flattenDetails, (Object)other.flattenDetails) && Objects.equals((Object)this.flattenField, (Object)other.flattenField) && Objects.equals((Object)this.materializedFlattenField, (Object)other.materializedFlattenField) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.flattenDetails == null ? 43 : this.flattenDetails.hashCode());
        result = result * 59 + (this.flattenField == null ? 43 : this.flattenField.hashCode());
        result = result * 59 + (this.materializedFlattenField == null ? 43 : this.materializedFlattenField.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="inputPorts")
        private List<InputPort> inputPorts;
        @JsonProperty(value="outputPorts")
        private List<TypedObject> outputPorts;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="parameters")
        private List<Parameter> parameters;
        @JsonProperty(value="opConfigValues")
        private ConfigValues opConfigValues;
        @JsonProperty(value="flattenDetails")
        private FlattenDetails flattenDetails;
        @JsonProperty(value="flattenField")
        private DynamicProxyField flattenField;
        @JsonProperty(value="materializedFlattenField")
        private MaterializedDynamicField materializedFlattenField;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder inputPorts(List<InputPort> inputPorts) {
            this.inputPorts = inputPorts;
            this.__explicitlySet__.add("inputPorts");
            return this;
        }

        public Builder outputPorts(List<TypedObject> outputPorts) {
            this.outputPorts = outputPorts;
            this.__explicitlySet__.add("outputPorts");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder parameters(List<Parameter> parameters) {
            this.parameters = parameters;
            this.__explicitlySet__.add("parameters");
            return this;
        }

        public Builder opConfigValues(ConfigValues opConfigValues) {
            this.opConfigValues = opConfigValues;
            this.__explicitlySet__.add("opConfigValues");
            return this;
        }

        public Builder flattenDetails(FlattenDetails flattenDetails) {
            this.flattenDetails = flattenDetails;
            this.__explicitlySet__.add("flattenDetails");
            return this;
        }

        public Builder flattenField(DynamicProxyField flattenField) {
            this.flattenField = flattenField;
            this.__explicitlySet__.add("flattenField");
            return this;
        }

        public Builder materializedFlattenField(MaterializedDynamicField materializedFlattenField) {
            this.materializedFlattenField = materializedFlattenField;
            this.__explicitlySet__.add("materializedFlattenField");
            return this;
        }

        public Flatten build() {
            Flatten model = new Flatten(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.inputPorts, this.outputPorts, this.objectStatus, this.identifier, this.parameters, this.opConfigValues, this.flattenDetails, this.flattenField, this.materializedFlattenField);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Flatten model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("inputPorts")) {
                this.inputPorts(model.getInputPorts());
            }
            if (model.wasPropertyExplicitlySet("outputPorts")) {
                this.outputPorts(model.getOutputPorts());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("parameters")) {
                this.parameters(model.getParameters());
            }
            if (model.wasPropertyExplicitlySet("opConfigValues")) {
                this.opConfigValues(model.getOpConfigValues());
            }
            if (model.wasPropertyExplicitlySet("flattenDetails")) {
                this.flattenDetails(model.getFlattenDetails());
            }
            if (model.wasPropertyExplicitlySet("flattenField")) {
                this.flattenField(model.getFlattenField());
            }
            if (model.wasPropertyExplicitlySet("materializedFlattenField")) {
                this.materializedFlattenField(model.getMaterializedFlattenField());
            }
            return this;
        }
    }
}

