/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConfigValues;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataflowApplication
extends ExplicitlySetBmcModel {
    @JsonProperty(value="applicationId")
    private final String applicationId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;

    @Deprecated
    @ConstructorProperties(value={"applicationId", "compartmentId", "configValues"})
    public DataflowApplication(String applicationId, String compartmentId, ConfigValues configValues) {
        this.applicationId = applicationId;
        this.compartmentId = compartmentId;
        this.configValues = configValues;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataflowApplication(");
        sb.append("super=").append(super.toString());
        sb.append("applicationId=").append(String.valueOf(this.applicationId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataflowApplication)) {
            return false;
        }
        DataflowApplication other = (DataflowApplication)((Object)o);
        return Objects.equals(this.applicationId, other.applicationId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.configValues, (Object)other.configValues) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.applicationId == null ? 43 : this.applicationId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="applicationId")
        private String applicationId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="configValues")
        private ConfigValues configValues;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            this.__explicitlySet__.add("applicationId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder configValues(ConfigValues configValues) {
            this.configValues = configValues;
            this.__explicitlySet__.add("configValues");
            return this;
        }

        public DataflowApplication build() {
            DataflowApplication model = new DataflowApplication(this.applicationId, this.compartmentId, this.configValues);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataflowApplication model) {
            if (model.wasPropertyExplicitlySet("applicationId")) {
                this.applicationId(model.getApplicationId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("configValues")) {
                this.configValues(model.getConfigValues());
            }
            return this;
        }
    }
}

