/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractFormatAttribute;
import com.oracle.bmc.dataintegration.model.Compression;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DataFormat
extends ExplicitlySetBmcModel {
    @JsonProperty(value="formatAttribute")
    private final AbstractFormatAttribute formatAttribute;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="compressionConfig")
    private final Compression compressionConfig;

    @Deprecated
    @ConstructorProperties(value={"formatAttribute", "type", "compressionConfig"})
    public DataFormat(AbstractFormatAttribute formatAttribute, Type type, Compression compressionConfig) {
        this.formatAttribute = formatAttribute;
        this.type = type;
        this.compressionConfig = compressionConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AbstractFormatAttribute getFormatAttribute() {
        return this.formatAttribute;
    }

    public Type getType() {
        return this.type;
    }

    public Compression getCompressionConfig() {
        return this.compressionConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataFormat(");
        sb.append("super=").append(super.toString());
        sb.append("formatAttribute=").append(String.valueOf((Object)this.formatAttribute));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", compressionConfig=").append(String.valueOf((Object)this.compressionConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataFormat)) {
            return false;
        }
        DataFormat other = (DataFormat)((Object)o);
        return Objects.equals((Object)this.formatAttribute, (Object)other.formatAttribute) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.compressionConfig, (Object)other.compressionConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.formatAttribute == null ? 43 : this.formatAttribute.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.compressionConfig == null ? 43 : this.compressionConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Xml("XML"),
        Json("JSON"),
        Csv("CSV"),
        Orc("ORC"),
        Parquet("PARQUET"),
        Avro("AVRO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="formatAttribute")
        private AbstractFormatAttribute formatAttribute;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="compressionConfig")
        private Compression compressionConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder formatAttribute(AbstractFormatAttribute formatAttribute) {
            this.formatAttribute = formatAttribute;
            this.__explicitlySet__.add("formatAttribute");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder compressionConfig(Compression compressionConfig) {
            this.compressionConfig = compressionConfig;
            this.__explicitlySet__.add("compressionConfig");
            return this;
        }

        public DataFormat build() {
            DataFormat model = new DataFormat(this.formatAttribute, this.type, this.compressionConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataFormat model) {
            if (model.wasPropertyExplicitlySet("formatAttribute")) {
                this.formatAttribute(model.getFormatAttribute());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("compressionConfig")) {
                this.compressionConfig(model.getCompressionConfig());
            }
            return this;
        }
    }
}

