/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractFormatAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CsvFormatAttribute
extends AbstractFormatAttribute {
    @JsonProperty(value="encoding")
    private final String encoding;
    @JsonProperty(value="escapeCharacter")
    private final String escapeCharacter;
    @JsonProperty(value="delimiter")
    private final String delimiter;
    @JsonProperty(value="quoteCharacter")
    private final String quoteCharacter;
    @JsonProperty(value="hasHeader")
    private final Boolean hasHeader;
    @JsonProperty(value="timestampFormat")
    private final String timestampFormat;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CsvFormatAttribute(Boolean isFilePattern, String encoding, String escapeCharacter, String delimiter, String quoteCharacter, Boolean hasHeader, String timestampFormat) {
        super(isFilePattern);
        this.encoding = encoding;
        this.escapeCharacter = escapeCharacter;
        this.delimiter = delimiter;
        this.quoteCharacter = quoteCharacter;
        this.hasHeader = hasHeader;
        this.timestampFormat = timestampFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public Boolean getHasHeader() {
        return this.hasHeader;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CsvFormatAttribute(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", encoding=").append(String.valueOf(this.encoding));
        sb.append(", escapeCharacter=").append(String.valueOf(this.escapeCharacter));
        sb.append(", delimiter=").append(String.valueOf(this.delimiter));
        sb.append(", quoteCharacter=").append(String.valueOf(this.quoteCharacter));
        sb.append(", hasHeader=").append(String.valueOf(this.hasHeader));
        sb.append(", timestampFormat=").append(String.valueOf(this.timestampFormat));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvFormatAttribute)) {
            return false;
        }
        CsvFormatAttribute other = (CsvFormatAttribute)((Object)o);
        return Objects.equals(this.encoding, other.encoding) && Objects.equals(this.escapeCharacter, other.escapeCharacter) && Objects.equals(this.delimiter, other.delimiter) && Objects.equals(this.quoteCharacter, other.quoteCharacter) && Objects.equals(this.hasHeader, other.hasHeader) && Objects.equals(this.timestampFormat, other.timestampFormat) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.encoding == null ? 43 : this.encoding.hashCode());
        result = result * 59 + (this.escapeCharacter == null ? 43 : this.escapeCharacter.hashCode());
        result = result * 59 + (this.delimiter == null ? 43 : this.delimiter.hashCode());
        result = result * 59 + (this.quoteCharacter == null ? 43 : this.quoteCharacter.hashCode());
        result = result * 59 + (this.hasHeader == null ? 43 : this.hasHeader.hashCode());
        result = result * 59 + (this.timestampFormat == null ? 43 : this.timestampFormat.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isFilePattern")
        private Boolean isFilePattern;
        @JsonProperty(value="encoding")
        private String encoding;
        @JsonProperty(value="escapeCharacter")
        private String escapeCharacter;
        @JsonProperty(value="delimiter")
        private String delimiter;
        @JsonProperty(value="quoteCharacter")
        private String quoteCharacter;
        @JsonProperty(value="hasHeader")
        private Boolean hasHeader;
        @JsonProperty(value="timestampFormat")
        private String timestampFormat;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isFilePattern(Boolean isFilePattern) {
            this.isFilePattern = isFilePattern;
            this.__explicitlySet__.add("isFilePattern");
            return this;
        }

        public Builder encoding(String encoding) {
            this.encoding = encoding;
            this.__explicitlySet__.add("encoding");
            return this;
        }

        public Builder escapeCharacter(String escapeCharacter) {
            this.escapeCharacter = escapeCharacter;
            this.__explicitlySet__.add("escapeCharacter");
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            this.__explicitlySet__.add("delimiter");
            return this;
        }

        public Builder quoteCharacter(String quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            this.__explicitlySet__.add("quoteCharacter");
            return this;
        }

        public Builder hasHeader(Boolean hasHeader) {
            this.hasHeader = hasHeader;
            this.__explicitlySet__.add("hasHeader");
            return this;
        }

        public Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            this.__explicitlySet__.add("timestampFormat");
            return this;
        }

        public CsvFormatAttribute build() {
            CsvFormatAttribute model = new CsvFormatAttribute(this.isFilePattern, this.encoding, this.escapeCharacter, this.delimiter, this.quoteCharacter, this.hasHeader, this.timestampFormat);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CsvFormatAttribute model) {
            if (model.wasPropertyExplicitlySet("isFilePattern")) {
                this.isFilePattern(model.getIsFilePattern());
            }
            if (model.wasPropertyExplicitlySet("encoding")) {
                this.encoding(model.getEncoding());
            }
            if (model.wasPropertyExplicitlySet("escapeCharacter")) {
                this.escapeCharacter(model.getEscapeCharacter());
            }
            if (model.wasPropertyExplicitlySet("delimiter")) {
                this.delimiter(model.getDelimiter());
            }
            if (model.wasPropertyExplicitlySet("quoteCharacter")) {
                this.quoteCharacter(model.getQuoteCharacter());
            }
            if (model.wasPropertyExplicitlySet("hasHeader")) {
                this.hasHeader(model.getHasHeader());
            }
            if (model.wasPropertyExplicitlySet("timestampFormat")) {
                this.timestampFormat(model.getTimestampFormat());
            }
            return this;
        }
    }
}

