/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.CreateConfigProvider;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateTaskRunDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelType")
    private final String modelType;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="configProvider")
    private final CreateConfigProvider configProvider;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="taskScheduleKey")
    private final String taskScheduleKey;
    @JsonProperty(value="refTaskRunId")
    private final String refTaskRunId;
    @JsonProperty(value="reRunType")
    private final ReRunType reRunType;
    @JsonProperty(value="stepId")
    private final String stepId;
    @JsonProperty(value="registryMetadata")
    private final RegistryMetadata registryMetadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelType", "modelVersion", "name", "description", "configProvider", "identifier", "taskScheduleKey", "refTaskRunId", "reRunType", "stepId", "registryMetadata"})
    public CreateTaskRunDetails(String key, String modelType, String modelVersion, String name, String description, CreateConfigProvider configProvider, String identifier, String taskScheduleKey, String refTaskRunId, ReRunType reRunType, String stepId, RegistryMetadata registryMetadata) {
        this.key = key;
        this.modelType = modelType;
        this.modelVersion = modelVersion;
        this.name = name;
        this.description = description;
        this.configProvider = configProvider;
        this.identifier = identifier;
        this.taskScheduleKey = taskScheduleKey;
        this.refTaskRunId = refTaskRunId;
        this.reRunType = reRunType;
        this.stepId = stepId;
        this.registryMetadata = registryMetadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getTaskScheduleKey() {
        return this.taskScheduleKey;
    }

    public String getRefTaskRunId() {
        return this.refTaskRunId;
    }

    public ReRunType getReRunType() {
        return this.reRunType;
    }

    public String getStepId() {
        return this.stepId;
    }

    public RegistryMetadata getRegistryMetadata() {
        return this.registryMetadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateTaskRunDetails(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelType=").append(String.valueOf(this.modelType));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", configProvider=").append(String.valueOf((Object)this.configProvider));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", taskScheduleKey=").append(String.valueOf(this.taskScheduleKey));
        sb.append(", refTaskRunId=").append(String.valueOf(this.refTaskRunId));
        sb.append(", reRunType=").append(String.valueOf((Object)this.reRunType));
        sb.append(", stepId=").append(String.valueOf(this.stepId));
        sb.append(", registryMetadata=").append(String.valueOf((Object)this.registryMetadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateTaskRunDetails)) {
            return false;
        }
        CreateTaskRunDetails other = (CreateTaskRunDetails)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelType, other.modelType) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.configProvider, (Object)other.configProvider) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.taskScheduleKey, other.taskScheduleKey) && Objects.equals(this.refTaskRunId, other.refTaskRunId) && Objects.equals((Object)this.reRunType, (Object)other.reRunType) && Objects.equals(this.stepId, other.stepId) && Objects.equals((Object)this.registryMetadata, (Object)other.registryMetadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelType == null ? 43 : this.modelType.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.configProvider == null ? 43 : this.configProvider.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.taskScheduleKey == null ? 43 : this.taskScheduleKey.hashCode());
        result = result * 59 + (this.refTaskRunId == null ? 43 : this.refTaskRunId.hashCode());
        result = result * 59 + (this.reRunType == null ? 43 : this.reRunType.hashCode());
        result = result * 59 + (this.stepId == null ? 43 : this.stepId.hashCode());
        result = result * 59 + (this.registryMetadata == null ? 43 : this.registryMetadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ReRunType implements BmcEnum
    {
        Beginning("BEGINNING"),
        Failed("FAILED"),
        Step("STEP");

        private final String value;
        private static Map<String, ReRunType> map;

        private ReRunType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ReRunType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ReRunType: " + key);
        }

        static {
            map = new HashMap<String, ReRunType>();
            for (ReRunType v : ReRunType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelType")
        private String modelType;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="configProvider")
        private CreateConfigProvider configProvider;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="taskScheduleKey")
        private String taskScheduleKey;
        @JsonProperty(value="refTaskRunId")
        private String refTaskRunId;
        @JsonProperty(value="reRunType")
        private ReRunType reRunType;
        @JsonProperty(value="stepId")
        private String stepId;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelType(String modelType) {
            this.modelType = modelType;
            this.__explicitlySet__.add("modelType");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder configProvider(CreateConfigProvider configProvider) {
            this.configProvider = configProvider;
            this.__explicitlySet__.add("configProvider");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder taskScheduleKey(String taskScheduleKey) {
            this.taskScheduleKey = taskScheduleKey;
            this.__explicitlySet__.add("taskScheduleKey");
            return this;
        }

        public Builder refTaskRunId(String refTaskRunId) {
            this.refTaskRunId = refTaskRunId;
            this.__explicitlySet__.add("refTaskRunId");
            return this;
        }

        public Builder reRunType(ReRunType reRunType) {
            this.reRunType = reRunType;
            this.__explicitlySet__.add("reRunType");
            return this;
        }

        public Builder stepId(String stepId) {
            this.stepId = stepId;
            this.__explicitlySet__.add("stepId");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public CreateTaskRunDetails build() {
            CreateTaskRunDetails model = new CreateTaskRunDetails(this.key, this.modelType, this.modelVersion, this.name, this.description, this.configProvider, this.identifier, this.taskScheduleKey, this.refTaskRunId, this.reRunType, this.stepId, this.registryMetadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateTaskRunDetails model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelType")) {
                this.modelType(model.getModelType());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("configProvider")) {
                this.configProvider(model.getConfigProvider());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("taskScheduleKey")) {
                this.taskScheduleKey(model.getTaskScheduleKey());
            }
            if (model.wasPropertyExplicitlySet("refTaskRunId")) {
                this.refTaskRunId(model.getRefTaskRunId());
            }
            if (model.wasPropertyExplicitlySet("reRunType")) {
                this.reRunType(model.getReRunType());
            }
            if (model.wasPropertyExplicitlySet("stepId")) {
                this.stepId(model.getStepId());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            return this;
        }
    }
}

