/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractFrequencyDetails;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateScheduleDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectVersion")
    private final Integer objectVersion;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="frequencyDetails")
    private final AbstractFrequencyDetails frequencyDetails;
    @JsonProperty(value="timezone")
    private final String timezone;
    @JsonProperty(value="isDaylightAdjustmentEnabled")
    private final Boolean isDaylightAdjustmentEnabled;
    @JsonProperty(value="registryMetadata")
    private final RegistryMetadata registryMetadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "name", "description", "objectVersion", "objectStatus", "identifier", "frequencyDetails", "timezone", "isDaylightAdjustmentEnabled", "registryMetadata"})
    public CreateScheduleDetails(String key, String modelVersion, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, AbstractFrequencyDetails frequencyDetails, String timezone, Boolean isDaylightAdjustmentEnabled, RegistryMetadata registryMetadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.name = name;
        this.description = description;
        this.objectVersion = objectVersion;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.frequencyDetails = frequencyDetails;
        this.timezone = timezone;
        this.isDaylightAdjustmentEnabled = isDaylightAdjustmentEnabled;
        this.registryMetadata = registryMetadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectVersion() {
        return this.objectVersion;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public AbstractFrequencyDetails getFrequencyDetails() {
        return this.frequencyDetails;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Boolean getIsDaylightAdjustmentEnabled() {
        return this.isDaylightAdjustmentEnabled;
    }

    public RegistryMetadata getRegistryMetadata() {
        return this.registryMetadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateScheduleDetails(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectVersion=").append(String.valueOf(this.objectVersion));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", frequencyDetails=").append(String.valueOf((Object)this.frequencyDetails));
        sb.append(", timezone=").append(String.valueOf(this.timezone));
        sb.append(", isDaylightAdjustmentEnabled=").append(String.valueOf(this.isDaylightAdjustmentEnabled));
        sb.append(", registryMetadata=").append(String.valueOf((Object)this.registryMetadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateScheduleDetails)) {
            return false;
        }
        CreateScheduleDetails other = (CreateScheduleDetails)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectVersion, other.objectVersion) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals((Object)this.frequencyDetails, (Object)other.frequencyDetails) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.isDaylightAdjustmentEnabled, other.isDaylightAdjustmentEnabled) && Objects.equals((Object)this.registryMetadata, (Object)other.registryMetadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectVersion == null ? 43 : this.objectVersion.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.frequencyDetails == null ? 43 : this.frequencyDetails.hashCode());
        result = result * 59 + (this.timezone == null ? 43 : this.timezone.hashCode());
        result = result * 59 + (this.isDaylightAdjustmentEnabled == null ? 43 : this.isDaylightAdjustmentEnabled.hashCode());
        result = result * 59 + (this.registryMetadata == null ? 43 : this.registryMetadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="frequencyDetails")
        private AbstractFrequencyDetails frequencyDetails;
        @JsonProperty(value="timezone")
        private String timezone;
        @JsonProperty(value="isDaylightAdjustmentEnabled")
        private Boolean isDaylightAdjustmentEnabled;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder frequencyDetails(AbstractFrequencyDetails frequencyDetails) {
            this.frequencyDetails = frequencyDetails;
            this.__explicitlySet__.add("frequencyDetails");
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            this.__explicitlySet__.add("timezone");
            return this;
        }

        public Builder isDaylightAdjustmentEnabled(Boolean isDaylightAdjustmentEnabled) {
            this.isDaylightAdjustmentEnabled = isDaylightAdjustmentEnabled;
            this.__explicitlySet__.add("isDaylightAdjustmentEnabled");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public CreateScheduleDetails build() {
            CreateScheduleDetails model = new CreateScheduleDetails(this.key, this.modelVersion, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.frequencyDetails, this.timezone, this.isDaylightAdjustmentEnabled, this.registryMetadata);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateScheduleDetails model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("frequencyDetails")) {
                this.frequencyDetails(model.getFrequencyDetails());
            }
            if (model.wasPropertyExplicitlySet("timezone")) {
                this.timezone(model.getTimezone());
            }
            if (model.wasPropertyExplicitlySet("isDaylightAdjustmentEnabled")) {
                this.isDaylightAdjustmentEnabled(model.getIsDaylightAdjustmentEnabled());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            return this;
        }
    }
}

