/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConnectionSummaryFromObjectStorage;
import com.oracle.bmc.dataintegration.model.CreateConnectionDetails;
import com.oracle.bmc.dataintegration.model.CreateDataAssetDetails;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromObjectStorage;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import com.oracle.bmc.dataintegration.model.Schema;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateDataAssetFromFusionApp
extends CreateDataAssetDetails {
    @JsonProperty(value="serviceUrl")
    private final String serviceUrl;
    @JsonProperty(value="defaultConnection")
    private final CreateConnectionDetails defaultConnection;
    @JsonProperty(value="stagingDataAsset")
    private final DataAssetSummaryFromObjectStorage stagingDataAsset;
    @JsonProperty(value="stagingConnection")
    private final ConnectionSummaryFromObjectStorage stagingConnection;
    @JsonProperty(value="bucketSchema")
    private final Schema bucketSchema;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateDataAssetFromFusionApp(String key, String modelVersion, String name, String description, Integer objectStatus, String identifier, String externalKey, Map<String, String> assetProperties, RegistryMetadata registryMetadata, String serviceUrl, CreateConnectionDetails defaultConnection, DataAssetSummaryFromObjectStorage stagingDataAsset, ConnectionSummaryFromObjectStorage stagingConnection, Schema bucketSchema) {
        super(key, modelVersion, name, description, objectStatus, identifier, externalKey, assetProperties, registryMetadata);
        this.serviceUrl = serviceUrl;
        this.defaultConnection = defaultConnection;
        this.stagingDataAsset = stagingDataAsset;
        this.stagingConnection = stagingConnection;
        this.bucketSchema = bucketSchema;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public CreateConnectionDetails getDefaultConnection() {
        return this.defaultConnection;
    }

    public DataAssetSummaryFromObjectStorage getStagingDataAsset() {
        return this.stagingDataAsset;
    }

    public ConnectionSummaryFromObjectStorage getStagingConnection() {
        return this.stagingConnection;
    }

    public Schema getBucketSchema() {
        return this.bucketSchema;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDataAssetFromFusionApp(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", serviceUrl=").append(String.valueOf(this.serviceUrl));
        sb.append(", defaultConnection=").append(String.valueOf((Object)this.defaultConnection));
        sb.append(", stagingDataAsset=").append(String.valueOf((Object)this.stagingDataAsset));
        sb.append(", stagingConnection=").append(String.valueOf((Object)this.stagingConnection));
        sb.append(", bucketSchema=").append(String.valueOf((Object)this.bucketSchema));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataAssetFromFusionApp)) {
            return false;
        }
        CreateDataAssetFromFusionApp other = (CreateDataAssetFromFusionApp)((Object)o);
        return Objects.equals(this.serviceUrl, other.serviceUrl) && Objects.equals((Object)this.defaultConnection, (Object)other.defaultConnection) && Objects.equals((Object)this.stagingDataAsset, (Object)other.stagingDataAsset) && Objects.equals((Object)this.stagingConnection, (Object)other.stagingConnection) && Objects.equals((Object)this.bucketSchema, (Object)other.bucketSchema) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.serviceUrl == null ? 43 : this.serviceUrl.hashCode());
        result = result * 59 + (this.defaultConnection == null ? 43 : this.defaultConnection.hashCode());
        result = result * 59 + (this.stagingDataAsset == null ? 43 : this.stagingDataAsset.hashCode());
        result = result * 59 + (this.stagingConnection == null ? 43 : this.stagingConnection.hashCode());
        result = result * 59 + (this.bucketSchema == null ? 43 : this.bucketSchema.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="externalKey")
        private String externalKey;
        @JsonProperty(value="assetProperties")
        private Map<String, String> assetProperties;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonProperty(value="serviceUrl")
        private String serviceUrl;
        @JsonProperty(value="defaultConnection")
        private CreateConnectionDetails defaultConnection;
        @JsonProperty(value="stagingDataAsset")
        private DataAssetSummaryFromObjectStorage stagingDataAsset;
        @JsonProperty(value="stagingConnection")
        private ConnectionSummaryFromObjectStorage stagingConnection;
        @JsonProperty(value="bucketSchema")
        private Schema bucketSchema;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder externalKey(String externalKey) {
            this.externalKey = externalKey;
            this.__explicitlySet__.add("externalKey");
            return this;
        }

        public Builder assetProperties(Map<String, String> assetProperties) {
            this.assetProperties = assetProperties;
            this.__explicitlySet__.add("assetProperties");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public Builder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            this.__explicitlySet__.add("serviceUrl");
            return this;
        }

        public Builder defaultConnection(CreateConnectionDetails defaultConnection) {
            this.defaultConnection = defaultConnection;
            this.__explicitlySet__.add("defaultConnection");
            return this;
        }

        public Builder stagingDataAsset(DataAssetSummaryFromObjectStorage stagingDataAsset) {
            this.stagingDataAsset = stagingDataAsset;
            this.__explicitlySet__.add("stagingDataAsset");
            return this;
        }

        public Builder stagingConnection(ConnectionSummaryFromObjectStorage stagingConnection) {
            this.stagingConnection = stagingConnection;
            this.__explicitlySet__.add("stagingConnection");
            return this;
        }

        public Builder bucketSchema(Schema bucketSchema) {
            this.bucketSchema = bucketSchema;
            this.__explicitlySet__.add("bucketSchema");
            return this;
        }

        public CreateDataAssetFromFusionApp build() {
            CreateDataAssetFromFusionApp model = new CreateDataAssetFromFusionApp(this.key, this.modelVersion, this.name, this.description, this.objectStatus, this.identifier, this.externalKey, this.assetProperties, this.registryMetadata, this.serviceUrl, this.defaultConnection, this.stagingDataAsset, this.stagingConnection, this.bucketSchema);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDataAssetFromFusionApp model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("externalKey")) {
                this.externalKey(model.getExternalKey());
            }
            if (model.wasPropertyExplicitlySet("assetProperties")) {
                this.assetProperties(model.getAssetProperties());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            if (model.wasPropertyExplicitlySet("serviceUrl")) {
                this.serviceUrl(model.getServiceUrl());
            }
            if (model.wasPropertyExplicitlySet("defaultConnection")) {
                this.defaultConnection(model.getDefaultConnection());
            }
            if (model.wasPropertyExplicitlySet("stagingDataAsset")) {
                this.stagingDataAsset(model.getStagingDataAsset());
            }
            if (model.wasPropertyExplicitlySet("stagingConnection")) {
                this.stagingConnection(model.getStagingConnection());
            }
            if (model.wasPropertyExplicitlySet("bucketSchema")) {
                this.bucketSchema(model.getBucketSchema());
            }
            return this;
        }
    }
}

