/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.CreateConnectionDetails;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import com.oracle.bmc.dataintegration.model.SensitiveAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateConnectionFromAdwc
extends CreateConnectionDetails {
    @JsonProperty(value="tnsAlias")
    private final String tnsAlias;
    @JsonProperty(value="tnsNames")
    private final List<String> tnsNames;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="passwordSecret")
    private final SensitiveAttribute passwordSecret;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateConnectionFromAdwc(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectStatus, String identifier, List<ConnectionProperty> connectionProperties, RegistryMetadata registryMetadata, String tnsAlias, List<String> tnsNames, String username, String password, SensitiveAttribute passwordSecret) {
        super(key, modelVersion, parentRef, name, description, objectStatus, identifier, connectionProperties, registryMetadata);
        this.tnsAlias = tnsAlias;
        this.tnsNames = tnsNames;
        this.username = username;
        this.password = password;
        this.passwordSecret = passwordSecret;
    }

    public String getTnsAlias() {
        return this.tnsAlias;
    }

    public List<String> getTnsNames() {
        return this.tnsNames;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SensitiveAttribute getPasswordSecret() {
        return this.passwordSecret;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateConnectionFromAdwc(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", tnsAlias=").append(String.valueOf(this.tnsAlias));
        sb.append(", tnsNames=").append(String.valueOf(this.tnsNames));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", password=").append(String.valueOf(this.password));
        sb.append(", passwordSecret=").append(String.valueOf((Object)this.passwordSecret));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateConnectionFromAdwc)) {
            return false;
        }
        CreateConnectionFromAdwc other = (CreateConnectionFromAdwc)((Object)o);
        return Objects.equals(this.tnsAlias, other.tnsAlias) && Objects.equals(this.tnsNames, other.tnsNames) && Objects.equals(this.username, other.username) && Objects.equals(this.password, other.password) && Objects.equals((Object)this.passwordSecret, (Object)other.passwordSecret) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tnsAlias == null ? 43 : this.tnsAlias.hashCode());
        result = result * 59 + (this.tnsNames == null ? 43 : this.tnsNames.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.password == null ? 43 : this.password.hashCode());
        result = result * 59 + (this.passwordSecret == null ? 43 : this.passwordSecret.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="connectionProperties")
        private List<ConnectionProperty> connectionProperties;
        @JsonProperty(value="registryMetadata")
        private RegistryMetadata registryMetadata;
        @JsonProperty(value="tnsAlias")
        private String tnsAlias;
        @JsonProperty(value="tnsNames")
        private List<String> tnsNames;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;
        @JsonProperty(value="passwordSecret")
        private SensitiveAttribute passwordSecret;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder connectionProperties(List<ConnectionProperty> connectionProperties) {
            this.connectionProperties = connectionProperties;
            this.__explicitlySet__.add("connectionProperties");
            return this;
        }

        public Builder registryMetadata(RegistryMetadata registryMetadata) {
            this.registryMetadata = registryMetadata;
            this.__explicitlySet__.add("registryMetadata");
            return this;
        }

        public Builder tnsAlias(String tnsAlias) {
            this.tnsAlias = tnsAlias;
            this.__explicitlySet__.add("tnsAlias");
            return this;
        }

        public Builder tnsNames(List<String> tnsNames) {
            this.tnsNames = tnsNames;
            this.__explicitlySet__.add("tnsNames");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            this.__explicitlySet__.add("password");
            return this;
        }

        public Builder passwordSecret(SensitiveAttribute passwordSecret) {
            this.passwordSecret = passwordSecret;
            this.__explicitlySet__.add("passwordSecret");
            return this;
        }

        public CreateConnectionFromAdwc build() {
            CreateConnectionFromAdwc model = new CreateConnectionFromAdwc(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectStatus, this.identifier, this.connectionProperties, this.registryMetadata, this.tnsAlias, this.tnsNames, this.username, this.password, this.passwordSecret);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateConnectionFromAdwc model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("connectionProperties")) {
                this.connectionProperties(model.getConnectionProperties());
            }
            if (model.wasPropertyExplicitlySet("registryMetadata")) {
                this.registryMetadata(model.getRegistryMetadata());
            }
            if (model.wasPropertyExplicitlySet("tnsAlias")) {
                this.tnsAlias(model.getTnsAlias());
            }
            if (model.wasPropertyExplicitlySet("tnsNames")) {
                this.tnsNames(model.getTnsNames());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("password")) {
                this.password(model.getPassword());
            }
            if (model.wasPropertyExplicitlySet("passwordSecret")) {
                this.passwordSecret(model.getPasswordSecret());
            }
            return this;
        }
    }
}

