/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataintegration.model.ConnectionProperty;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromAdwc;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromAmazonS3;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromAtp;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromBICC;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromBIP;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromJdbc;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromLakehouse;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromMySQL;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromObjectStorage;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromOracle;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromRestBasicAuth;
import com.oracle.bmc.dataintegration.model.CreateConnectionFromRestNoAuth;
import com.oracle.bmc.dataintegration.model.ParentReference;
import com.oracle.bmc.dataintegration.model.RegistryMetadata;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=CreateConnectionDetails.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CreateConnectionFromMySQL.class, name="MYSQL_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromAmazonS3.class, name="AMAZON_S3_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromLakehouse.class, name="LAKE_HOUSE_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromJdbc.class, name="GENERIC_JDBC_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromBICC.class, name="BICC_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromAtp.class, name="ORACLE_ATP_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromBIP.class, name="BIP_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromRestBasicAuth.class, name="REST_BASIC_AUTH_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromAdwc.class, name="ORACLE_ADWC_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromRestNoAuth.class, name="REST_NO_AUTH_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromOracle.class, name="ORACLEDB_CONNECTION"), @JsonSubTypes.Type(value=CreateConnectionFromObjectStorage.class, name="ORACLE_OBJECT_STORAGE_CONNECTION")})
@JsonFilter(value="explicitlySetFilter")
public class CreateConnectionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="identifier")
    private final String identifier;
    @JsonProperty(value="connectionProperties")
    private final List<ConnectionProperty> connectionProperties;
    @JsonProperty(value="registryMetadata")
    private final RegistryMetadata registryMetadata;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "name", "description", "objectStatus", "identifier", "connectionProperties", "registryMetadata"})
    protected CreateConnectionDetails(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectStatus, String identifier, List<ConnectionProperty> connectionProperties, RegistryMetadata registryMetadata) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.name = name;
        this.description = description;
        this.objectStatus = objectStatus;
        this.identifier = identifier;
        this.connectionProperties = connectionProperties;
        this.registryMetadata = registryMetadata;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<ConnectionProperty> getConnectionProperties() {
        return this.connectionProperties;
    }

    public RegistryMetadata getRegistryMetadata() {
        return this.registryMetadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateConnectionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", identifier=").append(String.valueOf(this.identifier));
        sb.append(", connectionProperties=").append(String.valueOf(this.connectionProperties));
        sb.append(", registryMetadata=").append(String.valueOf((Object)this.registryMetadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateConnectionDetails)) {
            return false;
        }
        CreateConnectionDetails other = (CreateConnectionDetails)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.connectionProperties, other.connectionProperties) && Objects.equals((Object)this.registryMetadata, (Object)other.registryMetadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.identifier == null ? 43 : this.identifier.hashCode());
        result = result * 59 + (this.connectionProperties == null ? 43 : this.connectionProperties.hashCode());
        result = result * 59 + (this.registryMetadata == null ? 43 : this.registryMetadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        OracleAdwcConnection("ORACLE_ADWC_CONNECTION"),
        OracleAtpConnection("ORACLE_ATP_CONNECTION"),
        OracleObjectStorageConnection("ORACLE_OBJECT_STORAGE_CONNECTION"),
        OracledbConnection("ORACLEDB_CONNECTION"),
        MysqlConnection("MYSQL_CONNECTION"),
        GenericJdbcConnection("GENERIC_JDBC_CONNECTION"),
        BiccConnection("BICC_CONNECTION"),
        AmazonS3Connection("AMAZON_S3_CONNECTION"),
        BipConnection("BIP_CONNECTION"),
        LakeHouseConnection("LAKE_HOUSE_CONNECTION"),
        RestNoAuthConnection("REST_NO_AUTH_CONNECTION"),
        RestBasicAuthConnection("REST_BASIC_AUTH_CONNECTION");

        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ModelType: " + key);
        }

        static {
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

