/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.ParameterValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConfigProvider
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bindings")
    private final Map<String, ParameterValue> bindings;
    @JsonProperty(value="childProviders")
    private final Map<String, ConfigProvider> childProviders;

    @Deprecated
    @ConstructorProperties(value={"bindings", "childProviders"})
    public ConfigProvider(Map<String, ParameterValue> bindings, Map<String, ConfigProvider> childProviders) {
        this.bindings = bindings;
        this.childProviders = childProviders;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Map<String, ParameterValue> getBindings() {
        return this.bindings;
    }

    public Map<String, ConfigProvider> getChildProviders() {
        return this.childProviders;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigProvider(");
        sb.append("super=").append(super.toString());
        sb.append("bindings=").append(String.valueOf(this.bindings));
        sb.append(", childProviders=").append(String.valueOf(this.childProviders));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigProvider)) {
            return false;
        }
        ConfigProvider other = (ConfigProvider)((Object)o);
        return Objects.equals(this.bindings, other.bindings) && Objects.equals(this.childProviders, other.childProviders) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bindings == null ? 43 : this.bindings.hashCode());
        result = result * 59 + (this.childProviders == null ? 43 : this.childProviders.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bindings")
        private Map<String, ParameterValue> bindings;
        @JsonProperty(value="childProviders")
        private Map<String, ConfigProvider> childProviders;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bindings(Map<String, ParameterValue> bindings) {
            this.bindings = bindings;
            this.__explicitlySet__.add("bindings");
            return this;
        }

        public Builder childProviders(Map<String, ConfigProvider> childProviders) {
            this.childProviders = childProviders;
            this.__explicitlySet__.add("childProviders");
            return this;
        }

        public ConfigProvider build() {
            ConfigProvider model = new ConfigProvider(this.bindings, this.childProviders);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConfigProvider model) {
            if (model.wasPropertyExplicitlySet("bindings")) {
                this.bindings(model.getBindings());
            }
            if (model.wasPropertyExplicitlySet("childProviders")) {
                this.childProviders(model.getChildProviders());
            }
            return this;
        }
    }
}

