/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataintegration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataintegration.model.AbstractReadAttribute;
import com.oracle.bmc.dataintegration.model.BipReportParameterValue;
import com.oracle.bmc.dataintegration.model.ConnectionSummaryFromObjectStorage;
import com.oracle.bmc.dataintegration.model.DataAssetSummaryFromObjectStorage;
import com.oracle.bmc.dataintegration.model.Schema;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class BipReadAttributes
extends AbstractReadAttribute {
    @JsonProperty(value="fetchSize")
    private final Integer fetchSize;
    @JsonProperty(value="rowLimit")
    private final Integer rowLimit;
    @JsonProperty(value="offsetParameter")
    private final String offsetParameter;
    @JsonProperty(value="fetchNextRowsParameter")
    private final String fetchNextRowsParameter;
    @JsonProperty(value="customParameters")
    private final List<BipReportParameterValue> customParameters;
    @JsonProperty(value="stagingDataAsset")
    private final DataAssetSummaryFromObjectStorage stagingDataAsset;
    @JsonProperty(value="stagingConnection")
    private final ConnectionSummaryFromObjectStorage stagingConnection;
    @JsonProperty(value="bucketSchema")
    private final Schema bucketSchema;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BipReadAttributes(Integer fetchSize, Integer rowLimit, String offsetParameter, String fetchNextRowsParameter, List<BipReportParameterValue> customParameters, DataAssetSummaryFromObjectStorage stagingDataAsset, ConnectionSummaryFromObjectStorage stagingConnection, Schema bucketSchema) {
        this.fetchSize = fetchSize;
        this.rowLimit = rowLimit;
        this.offsetParameter = offsetParameter;
        this.fetchNextRowsParameter = fetchNextRowsParameter;
        this.customParameters = customParameters;
        this.stagingDataAsset = stagingDataAsset;
        this.stagingConnection = stagingConnection;
        this.bucketSchema = bucketSchema;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public Integer getRowLimit() {
        return this.rowLimit;
    }

    public String getOffsetParameter() {
        return this.offsetParameter;
    }

    public String getFetchNextRowsParameter() {
        return this.fetchNextRowsParameter;
    }

    public List<BipReportParameterValue> getCustomParameters() {
        return this.customParameters;
    }

    public DataAssetSummaryFromObjectStorage getStagingDataAsset() {
        return this.stagingDataAsset;
    }

    public ConnectionSummaryFromObjectStorage getStagingConnection() {
        return this.stagingConnection;
    }

    public Schema getBucketSchema() {
        return this.bucketSchema;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BipReadAttributes(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", fetchSize=").append(String.valueOf(this.fetchSize));
        sb.append(", rowLimit=").append(String.valueOf(this.rowLimit));
        sb.append(", offsetParameter=").append(String.valueOf(this.offsetParameter));
        sb.append(", fetchNextRowsParameter=").append(String.valueOf(this.fetchNextRowsParameter));
        sb.append(", customParameters=").append(String.valueOf(this.customParameters));
        sb.append(", stagingDataAsset=").append(String.valueOf((Object)this.stagingDataAsset));
        sb.append(", stagingConnection=").append(String.valueOf((Object)this.stagingConnection));
        sb.append(", bucketSchema=").append(String.valueOf((Object)this.bucketSchema));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BipReadAttributes)) {
            return false;
        }
        BipReadAttributes other = (BipReadAttributes)((Object)o);
        return Objects.equals(this.fetchSize, other.fetchSize) && Objects.equals(this.rowLimit, other.rowLimit) && Objects.equals(this.offsetParameter, other.offsetParameter) && Objects.equals(this.fetchNextRowsParameter, other.fetchNextRowsParameter) && Objects.equals(this.customParameters, other.customParameters) && Objects.equals((Object)this.stagingDataAsset, (Object)other.stagingDataAsset) && Objects.equals((Object)this.stagingConnection, (Object)other.stagingConnection) && Objects.equals((Object)this.bucketSchema, (Object)other.bucketSchema) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fetchSize == null ? 43 : this.fetchSize.hashCode());
        result = result * 59 + (this.rowLimit == null ? 43 : this.rowLimit.hashCode());
        result = result * 59 + (this.offsetParameter == null ? 43 : this.offsetParameter.hashCode());
        result = result * 59 + (this.fetchNextRowsParameter == null ? 43 : this.fetchNextRowsParameter.hashCode());
        result = result * 59 + (this.customParameters == null ? 43 : this.customParameters.hashCode());
        result = result * 59 + (this.stagingDataAsset == null ? 43 : this.stagingDataAsset.hashCode());
        result = result * 59 + (this.stagingConnection == null ? 43 : this.stagingConnection.hashCode());
        result = result * 59 + (this.bucketSchema == null ? 43 : this.bucketSchema.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fetchSize")
        private Integer fetchSize;
        @JsonProperty(value="rowLimit")
        private Integer rowLimit;
        @JsonProperty(value="offsetParameter")
        private String offsetParameter;
        @JsonProperty(value="fetchNextRowsParameter")
        private String fetchNextRowsParameter;
        @JsonProperty(value="customParameters")
        private List<BipReportParameterValue> customParameters;
        @JsonProperty(value="stagingDataAsset")
        private DataAssetSummaryFromObjectStorage stagingDataAsset;
        @JsonProperty(value="stagingConnection")
        private ConnectionSummaryFromObjectStorage stagingConnection;
        @JsonProperty(value="bucketSchema")
        private Schema bucketSchema;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            this.__explicitlySet__.add("fetchSize");
            return this;
        }

        public Builder rowLimit(Integer rowLimit) {
            this.rowLimit = rowLimit;
            this.__explicitlySet__.add("rowLimit");
            return this;
        }

        public Builder offsetParameter(String offsetParameter) {
            this.offsetParameter = offsetParameter;
            this.__explicitlySet__.add("offsetParameter");
            return this;
        }

        public Builder fetchNextRowsParameter(String fetchNextRowsParameter) {
            this.fetchNextRowsParameter = fetchNextRowsParameter;
            this.__explicitlySet__.add("fetchNextRowsParameter");
            return this;
        }

        public Builder customParameters(List<BipReportParameterValue> customParameters) {
            this.customParameters = customParameters;
            this.__explicitlySet__.add("customParameters");
            return this;
        }

        public Builder stagingDataAsset(DataAssetSummaryFromObjectStorage stagingDataAsset) {
            this.stagingDataAsset = stagingDataAsset;
            this.__explicitlySet__.add("stagingDataAsset");
            return this;
        }

        public Builder stagingConnection(ConnectionSummaryFromObjectStorage stagingConnection) {
            this.stagingConnection = stagingConnection;
            this.__explicitlySet__.add("stagingConnection");
            return this;
        }

        public Builder bucketSchema(Schema bucketSchema) {
            this.bucketSchema = bucketSchema;
            this.__explicitlySet__.add("bucketSchema");
            return this;
        }

        public BipReadAttributes build() {
            BipReadAttributes model = new BipReadAttributes(this.fetchSize, this.rowLimit, this.offsetParameter, this.fetchNextRowsParameter, this.customParameters, this.stagingDataAsset, this.stagingConnection, this.bucketSchema);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BipReadAttributes model) {
            if (model.wasPropertyExplicitlySet("fetchSize")) {
                this.fetchSize(model.getFetchSize());
            }
            if (model.wasPropertyExplicitlySet("rowLimit")) {
                this.rowLimit(model.getRowLimit());
            }
            if (model.wasPropertyExplicitlySet("offsetParameter")) {
                this.offsetParameter(model.getOffsetParameter());
            }
            if (model.wasPropertyExplicitlySet("fetchNextRowsParameter")) {
                this.fetchNextRowsParameter(model.getFetchNextRowsParameter());
            }
            if (model.wasPropertyExplicitlySet("customParameters")) {
                this.customParameters(model.getCustomParameters());
            }
            if (model.wasPropertyExplicitlySet("stagingDataAsset")) {
                this.stagingDataAsset(model.getStagingDataAsset());
            }
            if (model.wasPropertyExplicitlySet("stagingConnection")) {
                this.stagingConnection(model.getStagingConnection());
            }
            if (model.wasPropertyExplicitlySet("bucketSchema")) {
                this.bucketSchema(model.getBucketSchema());
            }
            return this;
        }
    }
}

