/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.dataconnectivity.model.UpdateRegistryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateRegistryRequest
extends BmcRequest<UpdateRegistryDetails> {
    private String registryId;
    private UpdateRegistryDetails updateRegistryDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getRegistryId() {
        return this.registryId;
    }

    public UpdateRegistryDetails getUpdateRegistryDetails() {
        return this.updateRegistryDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateRegistryDetails getBody$() {
        return this.updateRegistryDetails;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).updateRegistryDetails(this.updateRegistryDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",updateRegistryDetails=").append(String.valueOf((Object)this.updateRegistryDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateRegistryRequest)) {
            return false;
        }
        UpdateRegistryRequest other = (UpdateRegistryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals((Object)this.updateRegistryDetails, (Object)other.updateRegistryDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.updateRegistryDetails == null ? 43 : this.updateRegistryDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateRegistryRequest, UpdateRegistryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private UpdateRegistryDetails updateRegistryDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder updateRegistryDetails(UpdateRegistryDetails updateRegistryDetails) {
            this.updateRegistryDetails = updateRegistryDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateRegistryRequest o) {
            this.registryId(o.getRegistryId());
            this.updateRegistryDetails(o.getUpdateRegistryDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateRegistryRequest build() {
            UpdateRegistryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateRegistryDetails body) {
            this.updateRegistryDetails(body);
            return this;
        }

        public UpdateRegistryRequest buildWithoutInvocationCallback() {
            UpdateRegistryRequest request = new UpdateRegistryRequest();
            request.registryId = this.registryId;
            request.updateRegistryDetails = this.updateRegistryDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

