/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetEngineConfigurationsRequest
extends BmcRequest<Void> {
    private String registryId;
    private String connectionKey;
    private EngineTypeQueryParam engineTypeQueryParam;
    private String opcRequestId;

    public String getRegistryId() {
        return this.registryId;
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public EngineTypeQueryParam getEngineTypeQueryParam() {
        return this.engineTypeQueryParam;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().registryId(this.registryId).connectionKey(this.connectionKey).engineTypeQueryParam(this.engineTypeQueryParam).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(",engineTypeQueryParam=").append(String.valueOf((Object)this.engineTypeQueryParam));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetEngineConfigurationsRequest)) {
            return false;
        }
        GetEngineConfigurationsRequest other = (GetEngineConfigurationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals((Object)this.engineTypeQueryParam, (Object)other.engineTypeQueryParam) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.engineTypeQueryParam == null ? 43 : this.engineTypeQueryParam.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEngineConfigurationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String registryId = null;
        private String connectionKey = null;
        private EngineTypeQueryParam engineTypeQueryParam = null;
        private String opcRequestId = null;

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            return this;
        }

        public Builder engineTypeQueryParam(EngineTypeQueryParam engineTypeQueryParam) {
            this.engineTypeQueryParam = engineTypeQueryParam;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEngineConfigurationsRequest o) {
            this.registryId(o.getRegistryId());
            this.connectionKey(o.getConnectionKey());
            this.engineTypeQueryParam(o.getEngineTypeQueryParam());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEngineConfigurationsRequest build() {
            GetEngineConfigurationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetEngineConfigurationsRequest buildWithoutInvocationCallback() {
            GetEngineConfigurationsRequest request = new GetEngineConfigurationsRequest();
            request.registryId = this.registryId;
            request.connectionKey = this.connectionKey;
            request.engineTypeQueryParam = this.engineTypeQueryParam;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum EngineTypeQueryParam implements BmcEnum
    {
        Spark("SPARK");

        private final String value;
        private static Map<String, EngineTypeQueryParam> map;

        private EngineTypeQueryParam(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EngineTypeQueryParam create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid EngineTypeQueryParam: " + key);
        }

        static {
            map = new HashMap<String, EngineTypeQueryParam>();
            for (EngineTypeQueryParam v : EngineTypeQueryParam.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

