/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteEndpointRequest
extends BmcRequest<Void> {
    private String endpointId;
    private String registryId;
    private Boolean isForceOperation;
    private String ifMatch;
    private String opcRequestId;

    public String getEndpointId() {
        return this.endpointId;
    }

    public String getRegistryId() {
        return this.registryId;
    }

    public Boolean getIsForceOperation() {
        return this.isForceOperation;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().endpointId(this.endpointId).registryId(this.registryId).isForceOperation(this.isForceOperation).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",endpointId=").append(String.valueOf(this.endpointId));
        sb.append(",registryId=").append(String.valueOf(this.registryId));
        sb.append(",isForceOperation=").append(String.valueOf(this.isForceOperation));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteEndpointRequest)) {
            return false;
        }
        DeleteEndpointRequest other = (DeleteEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.endpointId, other.endpointId) && Objects.equals(this.registryId, other.registryId) && Objects.equals(this.isForceOperation, other.isForceOperation) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.endpointId == null ? 43 : this.endpointId.hashCode());
        result = result * 59 + (this.registryId == null ? 43 : this.registryId.hashCode());
        result = result * 59 + (this.isForceOperation == null ? 43 : this.isForceOperation.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String endpointId = null;
        private String registryId = null;
        private Boolean isForceOperation = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public Builder isForceOperation(Boolean isForceOperation) {
            this.isForceOperation = isForceOperation;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteEndpointRequest o) {
            this.endpointId(o.getEndpointId());
            this.registryId(o.getRegistryId());
            this.isForceOperation(o.getIsForceOperation());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteEndpointRequest build() {
            DeleteEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteEndpointRequest buildWithoutInvocationCallback() {
            DeleteEndpointRequest request = new DeleteEndpointRequest();
            request.endpointId = this.endpointId;
            request.registryId = this.registryId;
            request.isForceOperation = this.isForceOperation;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

