/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataconnectivity.model.ConfigValues;
import com.oracle.bmc.dataconnectivity.model.InputPort;
import com.oracle.bmc.dataconnectivity.model.NativeShapeField;
import com.oracle.bmc.dataconnectivity.model.OutputPort;
import com.oracle.bmc.dataconnectivity.model.Parameter;
import com.oracle.bmc.dataconnectivity.model.ParentReference;
import com.oracle.bmc.dataconnectivity.model.Shape;
import com.oracle.bmc.dataconnectivity.model.ShapeField;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=TypedObject.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=OutputPort.class, name="OUTPUT_PORT"), @JsonSubTypes.Type(value=Shape.class, name="SHAPE"), @JsonSubTypes.Type(value=ShapeField.class, name="SHAPE_FIELD"), @JsonSubTypes.Type(value=InputPort.class, name="INPUT_PORT"), @JsonSubTypes.Type(value=Parameter.class, name="PARAMETER"), @JsonSubTypes.Type(value=NativeShapeField.class, name="NATIVE_SHAPE_FIELD")})
@JsonFilter(value="explicitlySetFilter")
public class TypedObject
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="modelVersion")
    private final String modelVersion;
    @JsonProperty(value="parentRef")
    private final ParentReference parentRef;
    @JsonProperty(value="configValues")
    private final ConfigValues configValues;
    @JsonProperty(value="objectStatus")
    private final Integer objectStatus;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"key", "modelVersion", "parentRef", "configValues", "objectStatus", "name", "description"})
    protected TypedObject(String key, String modelVersion, ParentReference parentRef, ConfigValues configValues, Integer objectStatus, String name, String description) {
        this.key = key;
        this.modelVersion = modelVersion;
        this.parentRef = parentRef;
        this.configValues = configValues;
        this.objectStatus = objectStatus;
        this.name = name;
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public ParentReference getParentRef() {
        return this.parentRef;
    }

    public ConfigValues getConfigValues() {
        return this.configValues;
    }

    public Integer getObjectStatus() {
        return this.objectStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TypedObject(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", modelVersion=").append(String.valueOf(this.modelVersion));
        sb.append(", parentRef=").append(String.valueOf((Object)this.parentRef));
        sb.append(", configValues=").append(String.valueOf((Object)this.configValues));
        sb.append(", objectStatus=").append(String.valueOf(this.objectStatus));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedObject)) {
            return false;
        }
        TypedObject other = (TypedObject)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.modelVersion, other.modelVersion) && Objects.equals((Object)this.parentRef, (Object)other.parentRef) && Objects.equals((Object)this.configValues, (Object)other.configValues) && Objects.equals(this.objectStatus, other.objectStatus) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.modelVersion == null ? 43 : this.modelVersion.hashCode());
        result = result * 59 + (this.parentRef == null ? 43 : this.parentRef.hashCode());
        result = result * 59 + (this.configValues == null ? 43 : this.configValues.hashCode());
        result = result * 59 + (this.objectStatus == null ? 43 : this.objectStatus.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        Shape("SHAPE"),
        ShapeField("SHAPE_FIELD"),
        NativeShapeField("NATIVE_SHAPE_FIELD");

        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ModelType: " + key);
        }

        static {
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

