/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.ShapeField;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SortClause
extends ExplicitlySetBmcModel {
    @JsonProperty(value="field")
    private final ShapeField field;
    @JsonProperty(value="order")
    private final Order order;

    @Deprecated
    @ConstructorProperties(value={"field", "order"})
    public SortClause(ShapeField field, Order order) {
        this.field = field;
        this.order = order;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ShapeField getField() {
        return this.field;
    }

    public Order getOrder() {
        return this.order;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SortClause(");
        sb.append("super=").append(super.toString());
        sb.append("field=").append(String.valueOf((Object)this.field));
        sb.append(", order=").append(String.valueOf((Object)this.order));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortClause)) {
            return false;
        }
        SortClause other = (SortClause)((Object)o);
        return Objects.equals((Object)this.field, (Object)other.field) && Objects.equals((Object)this.order, (Object)other.order) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.field == null ? 43 : this.field.hashCode());
        result = result * 59 + (this.order == null ? 43 : this.order.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Order implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, Order> map;

        private Order(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Order create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Order: " + key);
        }

        static {
            map = new HashMap<String, Order>();
            for (Order v : Order.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="field")
        private ShapeField field;
        @JsonProperty(value="order")
        private Order order;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder field(ShapeField field) {
            this.field = field;
            this.__explicitlySet__.add("field");
            return this;
        }

        public Builder order(Order order) {
            this.order = order;
            this.__explicitlySet__.add("order");
            return this;
        }

        public SortClause build() {
            SortClause model = new SortClause(this.field, this.order);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SortClause model) {
            if (model.wasPropertyExplicitlySet("field")) {
                this.field(model.getField());
            }
            if (model.wasPropertyExplicitlySet("order")) {
                this.order(model.getOrder());
            }
            return this;
        }
    }
}

