/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Outlier
extends ExplicitlySetBmcModel {
    @JsonProperty(value="low")
    private final String low;
    @JsonProperty(value="high")
    private final String high;
    @JsonProperty(value="lowCount")
    private final String lowCount;
    @JsonProperty(value="highCount")
    private final String highCount;

    @Deprecated
    @ConstructorProperties(value={"low", "high", "lowCount", "highCount"})
    public Outlier(String low, String high, String lowCount, String highCount) {
        this.low = low;
        this.high = high;
        this.lowCount = lowCount;
        this.highCount = highCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLow() {
        return this.low;
    }

    public String getHigh() {
        return this.high;
    }

    public String getLowCount() {
        return this.lowCount;
    }

    public String getHighCount() {
        return this.highCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Outlier(");
        sb.append("super=").append(super.toString());
        sb.append("low=").append(String.valueOf(this.low));
        sb.append(", high=").append(String.valueOf(this.high));
        sb.append(", lowCount=").append(String.valueOf(this.lowCount));
        sb.append(", highCount=").append(String.valueOf(this.highCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Outlier)) {
            return false;
        }
        Outlier other = (Outlier)((Object)o);
        return Objects.equals(this.low, other.low) && Objects.equals(this.high, other.high) && Objects.equals(this.lowCount, other.lowCount) && Objects.equals(this.highCount, other.highCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.low == null ? 43 : this.low.hashCode());
        result = result * 59 + (this.high == null ? 43 : this.high.hashCode());
        result = result * 59 + (this.lowCount == null ? 43 : this.lowCount.hashCode());
        result = result * 59 + (this.highCount == null ? 43 : this.highCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="low")
        private String low;
        @JsonProperty(value="high")
        private String high;
        @JsonProperty(value="lowCount")
        private String lowCount;
        @JsonProperty(value="highCount")
        private String highCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder low(String low) {
            this.low = low;
            this.__explicitlySet__.add("low");
            return this;
        }

        public Builder high(String high) {
            this.high = high;
            this.__explicitlySet__.add("high");
            return this;
        }

        public Builder lowCount(String lowCount) {
            this.lowCount = lowCount;
            this.__explicitlySet__.add("lowCount");
            return this;
        }

        public Builder highCount(String highCount) {
            this.highCount = highCount;
            this.__explicitlySet__.add("highCount");
            return this;
        }

        public Outlier build() {
            Outlier model = new Outlier(this.low, this.high, this.lowCount, this.highCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Outlier model) {
            if (model.wasPropertyExplicitlySet("low")) {
                this.low(model.getLow());
            }
            if (model.wasPropertyExplicitlySet("high")) {
                this.high(model.getHigh());
            }
            if (model.wasPropertyExplicitlySet("lowCount")) {
                this.lowCount(model.getLowCount());
            }
            if (model.wasPropertyExplicitlySet("highCount")) {
                this.highCount(model.getHighCount());
            }
            return this;
        }
    }
}

