/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OperationExecResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="executionStatus")
    private final ExecutionStatus executionStatus;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="metrics")
    private final Object metrics;
    @JsonProperty(value="outputValues")
    private final List<List<Object>> outputValues;
    @JsonProperty(value="isWhitelistedErrorMessage")
    private final Boolean isWhitelistedErrorMessage;

    @Deprecated
    @ConstructorProperties(value={"executionStatus", "errorMessage", "metrics", "outputValues", "isWhitelistedErrorMessage"})
    public OperationExecResult(ExecutionStatus executionStatus, String errorMessage, Object metrics, List<List<Object>> outputValues, Boolean isWhitelistedErrorMessage) {
        this.executionStatus = executionStatus;
        this.errorMessage = errorMessage;
        this.metrics = metrics;
        this.outputValues = outputValues;
        this.isWhitelistedErrorMessage = isWhitelistedErrorMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ExecutionStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Object getMetrics() {
        return this.metrics;
    }

    public List<List<Object>> getOutputValues() {
        return this.outputValues;
    }

    public Boolean getIsWhitelistedErrorMessage() {
        return this.isWhitelistedErrorMessage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OperationExecResult(");
        sb.append("super=").append(super.toString());
        sb.append("executionStatus=").append(String.valueOf((Object)this.executionStatus));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", metrics=").append(String.valueOf(this.metrics));
        sb.append(", outputValues=").append(String.valueOf(this.outputValues));
        sb.append(", isWhitelistedErrorMessage=").append(String.valueOf(this.isWhitelistedErrorMessage));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperationExecResult)) {
            return false;
        }
        OperationExecResult other = (OperationExecResult)((Object)o);
        return Objects.equals((Object)this.executionStatus, (Object)other.executionStatus) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.metrics, other.metrics) && Objects.equals(this.outputValues, other.outputValues) && Objects.equals(this.isWhitelistedErrorMessage, other.isWhitelistedErrorMessage) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.executionStatus == null ? 43 : this.executionStatus.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.metrics == null ? 43 : this.metrics.hashCode());
        result = result * 59 + (this.outputValues == null ? 43 : this.outputValues.hashCode());
        result = result * 59 + (this.isWhitelistedErrorMessage == null ? 43 : this.isWhitelistedErrorMessage.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ExecutionStatus implements BmcEnum
    {
        Failed("FAILED"),
        Success("SUCCESS"),
        Queued("QUEUED"),
        Running("RUNNING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExecutionStatus> map;

        private ExecutionStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExecutionStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExecutionStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExecutionStatus.class);
            map = new HashMap<String, ExecutionStatus>();
            for (ExecutionStatus v : ExecutionStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="executionStatus")
        private ExecutionStatus executionStatus;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="metrics")
        private Object metrics;
        @JsonProperty(value="outputValues")
        private List<List<Object>> outputValues;
        @JsonProperty(value="isWhitelistedErrorMessage")
        private Boolean isWhitelistedErrorMessage;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            this.__explicitlySet__.add("executionStatus");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder metrics(Object metrics) {
            this.metrics = metrics;
            this.__explicitlySet__.add("metrics");
            return this;
        }

        public Builder outputValues(List<List<Object>> outputValues) {
            this.outputValues = outputValues;
            this.__explicitlySet__.add("outputValues");
            return this;
        }

        public Builder isWhitelistedErrorMessage(Boolean isWhitelistedErrorMessage) {
            this.isWhitelistedErrorMessage = isWhitelistedErrorMessage;
            this.__explicitlySet__.add("isWhitelistedErrorMessage");
            return this;
        }

        public OperationExecResult build() {
            OperationExecResult model = new OperationExecResult(this.executionStatus, this.errorMessage, this.metrics, this.outputValues, this.isWhitelistedErrorMessage);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OperationExecResult model) {
            if (model.wasPropertyExplicitlySet("executionStatus")) {
                this.executionStatus(model.getExecutionStatus());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("metrics")) {
                this.metrics(model.getMetrics());
            }
            if (model.wasPropertyExplicitlySet("outputValues")) {
                this.outputValues(model.getOutputValues());
            }
            if (model.wasPropertyExplicitlySet("isWhitelistedErrorMessage")) {
                this.isWhitelistedErrorMessage(model.getIsWhitelistedErrorMessage());
            }
            return this;
        }
    }
}

