/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.AttributeProfileResult;
import com.oracle.bmc.dataconnectivity.model.Histogram;
import com.oracle.bmc.dataconnectivity.model.ObjectFreqStat;
import com.oracle.bmc.dataconnectivity.model.Outlier;
import com.oracle.bmc.dataconnectivity.model.ProfileStat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class NumericAttribute
extends AttributeProfileResult {
    @JsonProperty(value="mean")
    private final ProfileStat mean;
    @JsonProperty(value="median")
    private final ProfileStat median;
    @JsonProperty(value="standardDeviation")
    private final ProfileStat standardDeviation;
    @JsonProperty(value="variance")
    private final ProfileStat variance;
    @JsonProperty(value="outlier")
    private final Outlier outlier;
    @JsonProperty(value="histogram")
    private final Histogram histogram;
    @JsonProperty(value="patternFrequencies")
    private final List<ObjectFreqStat> patternFrequencies;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public NumericAttribute(String name, ProfileStat min, ProfileStat max, ProfileStat nullCount, ProfileStat distinctCount, ProfileStat uniqueCount, ProfileStat duplicateCount, List<ObjectFreqStat> valueFrequencies, ProfileStat mean, ProfileStat median, ProfileStat standardDeviation, ProfileStat variance, Outlier outlier, Histogram histogram, List<ObjectFreqStat> patternFrequencies) {
        super(name, min, max, nullCount, distinctCount, uniqueCount, duplicateCount, valueFrequencies);
        this.mean = mean;
        this.median = median;
        this.standardDeviation = standardDeviation;
        this.variance = variance;
        this.outlier = outlier;
        this.histogram = histogram;
        this.patternFrequencies = patternFrequencies;
    }

    public ProfileStat getMean() {
        return this.mean;
    }

    public ProfileStat getMedian() {
        return this.median;
    }

    public ProfileStat getStandardDeviation() {
        return this.standardDeviation;
    }

    public ProfileStat getVariance() {
        return this.variance;
    }

    public Outlier getOutlier() {
        return this.outlier;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public List<ObjectFreqStat> getPatternFrequencies() {
        return this.patternFrequencies;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NumericAttribute(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", mean=").append(String.valueOf((Object)this.mean));
        sb.append(", median=").append(String.valueOf((Object)this.median));
        sb.append(", standardDeviation=").append(String.valueOf((Object)this.standardDeviation));
        sb.append(", variance=").append(String.valueOf((Object)this.variance));
        sb.append(", outlier=").append(String.valueOf((Object)this.outlier));
        sb.append(", histogram=").append(String.valueOf((Object)this.histogram));
        sb.append(", patternFrequencies=").append(String.valueOf(this.patternFrequencies));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumericAttribute)) {
            return false;
        }
        NumericAttribute other = (NumericAttribute)((Object)o);
        return Objects.equals((Object)this.mean, (Object)other.mean) && Objects.equals((Object)this.median, (Object)other.median) && Objects.equals((Object)this.standardDeviation, (Object)other.standardDeviation) && Objects.equals((Object)this.variance, (Object)other.variance) && Objects.equals((Object)this.outlier, (Object)other.outlier) && Objects.equals((Object)this.histogram, (Object)other.histogram) && Objects.equals(this.patternFrequencies, other.patternFrequencies) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.mean == null ? 43 : this.mean.hashCode());
        result = result * 59 + (this.median == null ? 43 : this.median.hashCode());
        result = result * 59 + (this.standardDeviation == null ? 43 : this.standardDeviation.hashCode());
        result = result * 59 + (this.variance == null ? 43 : this.variance.hashCode());
        result = result * 59 + (this.outlier == null ? 43 : this.outlier.hashCode());
        result = result * 59 + (this.histogram == null ? 43 : this.histogram.hashCode());
        result = result * 59 + (this.patternFrequencies == null ? 43 : this.patternFrequencies.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="min")
        private ProfileStat min;
        @JsonProperty(value="max")
        private ProfileStat max;
        @JsonProperty(value="nullCount")
        private ProfileStat nullCount;
        @JsonProperty(value="distinctCount")
        private ProfileStat distinctCount;
        @JsonProperty(value="uniqueCount")
        private ProfileStat uniqueCount;
        @JsonProperty(value="duplicateCount")
        private ProfileStat duplicateCount;
        @JsonProperty(value="valueFrequencies")
        private List<ObjectFreqStat> valueFrequencies;
        @JsonProperty(value="mean")
        private ProfileStat mean;
        @JsonProperty(value="median")
        private ProfileStat median;
        @JsonProperty(value="standardDeviation")
        private ProfileStat standardDeviation;
        @JsonProperty(value="variance")
        private ProfileStat variance;
        @JsonProperty(value="outlier")
        private Outlier outlier;
        @JsonProperty(value="histogram")
        private Histogram histogram;
        @JsonProperty(value="patternFrequencies")
        private List<ObjectFreqStat> patternFrequencies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder min(ProfileStat min) {
            this.min = min;
            this.__explicitlySet__.add("min");
            return this;
        }

        public Builder max(ProfileStat max) {
            this.max = max;
            this.__explicitlySet__.add("max");
            return this;
        }

        public Builder nullCount(ProfileStat nullCount) {
            this.nullCount = nullCount;
            this.__explicitlySet__.add("nullCount");
            return this;
        }

        public Builder distinctCount(ProfileStat distinctCount) {
            this.distinctCount = distinctCount;
            this.__explicitlySet__.add("distinctCount");
            return this;
        }

        public Builder uniqueCount(ProfileStat uniqueCount) {
            this.uniqueCount = uniqueCount;
            this.__explicitlySet__.add("uniqueCount");
            return this;
        }

        public Builder duplicateCount(ProfileStat duplicateCount) {
            this.duplicateCount = duplicateCount;
            this.__explicitlySet__.add("duplicateCount");
            return this;
        }

        public Builder valueFrequencies(List<ObjectFreqStat> valueFrequencies) {
            this.valueFrequencies = valueFrequencies;
            this.__explicitlySet__.add("valueFrequencies");
            return this;
        }

        public Builder mean(ProfileStat mean) {
            this.mean = mean;
            this.__explicitlySet__.add("mean");
            return this;
        }

        public Builder median(ProfileStat median) {
            this.median = median;
            this.__explicitlySet__.add("median");
            return this;
        }

        public Builder standardDeviation(ProfileStat standardDeviation) {
            this.standardDeviation = standardDeviation;
            this.__explicitlySet__.add("standardDeviation");
            return this;
        }

        public Builder variance(ProfileStat variance) {
            this.variance = variance;
            this.__explicitlySet__.add("variance");
            return this;
        }

        public Builder outlier(Outlier outlier) {
            this.outlier = outlier;
            this.__explicitlySet__.add("outlier");
            return this;
        }

        public Builder histogram(Histogram histogram) {
            this.histogram = histogram;
            this.__explicitlySet__.add("histogram");
            return this;
        }

        public Builder patternFrequencies(List<ObjectFreqStat> patternFrequencies) {
            this.patternFrequencies = patternFrequencies;
            this.__explicitlySet__.add("patternFrequencies");
            return this;
        }

        public NumericAttribute build() {
            NumericAttribute model = new NumericAttribute(this.name, this.min, this.max, this.nullCount, this.distinctCount, this.uniqueCount, this.duplicateCount, this.valueFrequencies, this.mean, this.median, this.standardDeviation, this.variance, this.outlier, this.histogram, this.patternFrequencies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NumericAttribute model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("min")) {
                this.min(model.getMin());
            }
            if (model.wasPropertyExplicitlySet("max")) {
                this.max(model.getMax());
            }
            if (model.wasPropertyExplicitlySet("nullCount")) {
                this.nullCount(model.getNullCount());
            }
            if (model.wasPropertyExplicitlySet("distinctCount")) {
                this.distinctCount(model.getDistinctCount());
            }
            if (model.wasPropertyExplicitlySet("uniqueCount")) {
                this.uniqueCount(model.getUniqueCount());
            }
            if (model.wasPropertyExplicitlySet("duplicateCount")) {
                this.duplicateCount(model.getDuplicateCount());
            }
            if (model.wasPropertyExplicitlySet("valueFrequencies")) {
                this.valueFrequencies(model.getValueFrequencies());
            }
            if (model.wasPropertyExplicitlySet("mean")) {
                this.mean(model.getMean());
            }
            if (model.wasPropertyExplicitlySet("median")) {
                this.median(model.getMedian());
            }
            if (model.wasPropertyExplicitlySet("standardDeviation")) {
                this.standardDeviation(model.getStandardDeviation());
            }
            if (model.wasPropertyExplicitlySet("variance")) {
                this.variance(model.getVariance());
            }
            if (model.wasPropertyExplicitlySet("outlier")) {
                this.outlier(model.getOutlier());
            }
            if (model.wasPropertyExplicitlySet("histogram")) {
                this.histogram(model.getHistogram());
            }
            if (model.wasPropertyExplicitlySet("patternFrequencies")) {
                this.patternFrequencies(model.getPatternFrequencies());
            }
            return this;
        }
    }
}

