/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EntityProfileResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="attributeCount")
    private final Integer attributeCount;
    @JsonProperty(value="sampledRowCount")
    private final Integer sampledRowCount;
    @JsonProperty(value="estimatedRowCount")
    private final Integer estimatedRowCount;

    @Deprecated
    @ConstructorProperties(value={"attributeCount", "sampledRowCount", "estimatedRowCount"})
    public EntityProfileResult(Integer attributeCount, Integer sampledRowCount, Integer estimatedRowCount) {
        this.attributeCount = attributeCount;
        this.sampledRowCount = sampledRowCount;
        this.estimatedRowCount = estimatedRowCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getAttributeCount() {
        return this.attributeCount;
    }

    public Integer getSampledRowCount() {
        return this.sampledRowCount;
    }

    public Integer getEstimatedRowCount() {
        return this.estimatedRowCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityProfileResult(");
        sb.append("super=").append(super.toString());
        sb.append("attributeCount=").append(String.valueOf(this.attributeCount));
        sb.append(", sampledRowCount=").append(String.valueOf(this.sampledRowCount));
        sb.append(", estimatedRowCount=").append(String.valueOf(this.estimatedRowCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityProfileResult)) {
            return false;
        }
        EntityProfileResult other = (EntityProfileResult)((Object)o);
        return Objects.equals(this.attributeCount, other.attributeCount) && Objects.equals(this.sampledRowCount, other.sampledRowCount) && Objects.equals(this.estimatedRowCount, other.estimatedRowCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.attributeCount == null ? 43 : this.attributeCount.hashCode());
        result = result * 59 + (this.sampledRowCount == null ? 43 : this.sampledRowCount.hashCode());
        result = result * 59 + (this.estimatedRowCount == null ? 43 : this.estimatedRowCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="attributeCount")
        private Integer attributeCount;
        @JsonProperty(value="sampledRowCount")
        private Integer sampledRowCount;
        @JsonProperty(value="estimatedRowCount")
        private Integer estimatedRowCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder attributeCount(Integer attributeCount) {
            this.attributeCount = attributeCount;
            this.__explicitlySet__.add("attributeCount");
            return this;
        }

        public Builder sampledRowCount(Integer sampledRowCount) {
            this.sampledRowCount = sampledRowCount;
            this.__explicitlySet__.add("sampledRowCount");
            return this;
        }

        public Builder estimatedRowCount(Integer estimatedRowCount) {
            this.estimatedRowCount = estimatedRowCount;
            this.__explicitlySet__.add("estimatedRowCount");
            return this;
        }

        public EntityProfileResult build() {
            EntityProfileResult model = new EntityProfileResult(this.attributeCount, this.sampledRowCount, this.estimatedRowCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EntityProfileResult model) {
            if (model.wasPropertyExplicitlySet("attributeCount")) {
                this.attributeCount(model.getAttributeCount());
            }
            if (model.wasPropertyExplicitlySet("sampledRowCount")) {
                this.sampledRowCount(model.getSampledRowCount());
            }
            if (model.wasPropertyExplicitlySet("estimatedRowCount")) {
                this.estimatedRowCount(model.getEstimatedRowCount());
            }
            return this;
        }
    }
}

