/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.DataAsset;
import com.oracle.bmc.dataconnectivity.model.DpEndpointSummary;
import com.oracle.bmc.dataconnectivity.model.ParentReference;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class DpEndpointSummaryFromPrivate
extends DpEndpointSummary {
    @JsonProperty(value="dcmsEndpointId")
    private final String dcmsEndpointId;
    @JsonProperty(value="peId")
    private final String peId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dnsProxyIp")
    private final String dnsProxyIp;
    @JsonProperty(value="privateEndpointIp")
    private final String privateEndpointIp;
    @JsonProperty(value="dnsZones")
    private final List<String> dnsZones;
    @JsonProperty(value="state")
    private final State state;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DpEndpointSummaryFromPrivate(String key, String modelVersion, ParentReference parentRef, String name, String description, Integer objectVersion, Integer objectStatus, String identifier, List<DataAsset> dataAssets, String dcmsEndpointId, String peId, String compartmentId, String dnsProxyIp, String privateEndpointIp, List<String> dnsZones, State state) {
        super(key, modelVersion, parentRef, name, description, objectVersion, objectStatus, identifier, dataAssets);
        this.dcmsEndpointId = dcmsEndpointId;
        this.peId = peId;
        this.compartmentId = compartmentId;
        this.dnsProxyIp = dnsProxyIp;
        this.privateEndpointIp = privateEndpointIp;
        this.dnsZones = dnsZones;
        this.state = state;
    }

    public String getDcmsEndpointId() {
        return this.dcmsEndpointId;
    }

    public String getPeId() {
        return this.peId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDnsProxyIp() {
        return this.dnsProxyIp;
    }

    public String getPrivateEndpointIp() {
        return this.privateEndpointIp;
    }

    public List<String> getDnsZones() {
        return this.dnsZones;
    }

    public State getState() {
        return this.state;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DpEndpointSummaryFromPrivate(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", dcmsEndpointId=").append(String.valueOf(this.dcmsEndpointId));
        sb.append(", peId=").append(String.valueOf(this.peId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dnsProxyIp=").append(String.valueOf(this.dnsProxyIp));
        sb.append(", privateEndpointIp=").append(String.valueOf(this.privateEndpointIp));
        sb.append(", dnsZones=").append(String.valueOf(this.dnsZones));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DpEndpointSummaryFromPrivate)) {
            return false;
        }
        DpEndpointSummaryFromPrivate other = (DpEndpointSummaryFromPrivate)((Object)o);
        return Objects.equals(this.dcmsEndpointId, other.dcmsEndpointId) && Objects.equals(this.peId, other.peId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dnsProxyIp, other.dnsProxyIp) && Objects.equals(this.privateEndpointIp, other.privateEndpointIp) && Objects.equals(this.dnsZones, other.dnsZones) && Objects.equals((Object)this.state, (Object)other.state) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dcmsEndpointId == null ? 43 : this.dcmsEndpointId.hashCode());
        result = result * 59 + (this.peId == null ? 43 : this.peId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dnsProxyIp == null ? 43 : this.dnsProxyIp.hashCode());
        result = result * 59 + (this.privateEndpointIp == null ? 43 : this.privateEndpointIp.hashCode());
        result = result * 59 + (this.dnsZones == null ? 43 : this.dnsZones.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        return result;
    }

    public static enum State implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE");

        private final String value;
        private static Map<String, State> map;

        private State(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static State create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid State: " + key);
        }

        static {
            map = new HashMap<String, State>();
            for (State v : State.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="modelVersion")
        private String modelVersion;
        @JsonProperty(value="parentRef")
        private ParentReference parentRef;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="objectVersion")
        private Integer objectVersion;
        @JsonProperty(value="objectStatus")
        private Integer objectStatus;
        @JsonProperty(value="identifier")
        private String identifier;
        @JsonProperty(value="dataAssets")
        private List<DataAsset> dataAssets;
        @JsonProperty(value="dcmsEndpointId")
        private String dcmsEndpointId;
        @JsonProperty(value="peId")
        private String peId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dnsProxyIp")
        private String dnsProxyIp;
        @JsonProperty(value="privateEndpointIp")
        private String privateEndpointIp;
        @JsonProperty(value="dnsZones")
        private List<String> dnsZones;
        @JsonProperty(value="state")
        private State state;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            this.__explicitlySet__.add("modelVersion");
            return this;
        }

        public Builder parentRef(ParentReference parentRef) {
            this.parentRef = parentRef;
            this.__explicitlySet__.add("parentRef");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder objectVersion(Integer objectVersion) {
            this.objectVersion = objectVersion;
            this.__explicitlySet__.add("objectVersion");
            return this;
        }

        public Builder objectStatus(Integer objectStatus) {
            this.objectStatus = objectStatus;
            this.__explicitlySet__.add("objectStatus");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.__explicitlySet__.add("identifier");
            return this;
        }

        public Builder dataAssets(List<DataAsset> dataAssets) {
            this.dataAssets = dataAssets;
            this.__explicitlySet__.add("dataAssets");
            return this;
        }

        public Builder dcmsEndpointId(String dcmsEndpointId) {
            this.dcmsEndpointId = dcmsEndpointId;
            this.__explicitlySet__.add("dcmsEndpointId");
            return this;
        }

        public Builder peId(String peId) {
            this.peId = peId;
            this.__explicitlySet__.add("peId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dnsProxyIp(String dnsProxyIp) {
            this.dnsProxyIp = dnsProxyIp;
            this.__explicitlySet__.add("dnsProxyIp");
            return this;
        }

        public Builder privateEndpointIp(String privateEndpointIp) {
            this.privateEndpointIp = privateEndpointIp;
            this.__explicitlySet__.add("privateEndpointIp");
            return this;
        }

        public Builder dnsZones(List<String> dnsZones) {
            this.dnsZones = dnsZones;
            this.__explicitlySet__.add("dnsZones");
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public DpEndpointSummaryFromPrivate build() {
            DpEndpointSummaryFromPrivate model = new DpEndpointSummaryFromPrivate(this.key, this.modelVersion, this.parentRef, this.name, this.description, this.objectVersion, this.objectStatus, this.identifier, this.dataAssets, this.dcmsEndpointId, this.peId, this.compartmentId, this.dnsProxyIp, this.privateEndpointIp, this.dnsZones, this.state);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DpEndpointSummaryFromPrivate model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("modelVersion")) {
                this.modelVersion(model.getModelVersion());
            }
            if (model.wasPropertyExplicitlySet("parentRef")) {
                this.parentRef(model.getParentRef());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("objectVersion")) {
                this.objectVersion(model.getObjectVersion());
            }
            if (model.wasPropertyExplicitlySet("objectStatus")) {
                this.objectStatus(model.getObjectStatus());
            }
            if (model.wasPropertyExplicitlySet("identifier")) {
                this.identifier(model.getIdentifier());
            }
            if (model.wasPropertyExplicitlySet("dataAssets")) {
                this.dataAssets(model.getDataAssets());
            }
            if (model.wasPropertyExplicitlySet("dcmsEndpointId")) {
                this.dcmsEndpointId(model.getDcmsEndpointId());
            }
            if (model.wasPropertyExplicitlySet("peId")) {
                this.peId(model.getPeId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dnsProxyIp")) {
                this.dnsProxyIp(model.getDnsProxyIp());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointIp")) {
                this.privateEndpointIp(model.getPrivateEndpointIp());
            }
            if (model.wasPropertyExplicitlySet("dnsZones")) {
                this.dnsZones(model.getDnsZones());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            return this;
        }
    }
}

