/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dataconnectivity.model.DataEntityFromDataStore;
import com.oracle.bmc.dataconnectivity.model.DataEntityFromFile;
import com.oracle.bmc.dataconnectivity.model.DataEntityFromSql;
import com.oracle.bmc.dataconnectivity.model.DataEntityFromTable;
import com.oracle.bmc.dataconnectivity.model.DataEntityFromView;
import com.oracle.bmc.dataconnectivity.model.DerivedEntity;
import com.oracle.bmc.dataconnectivity.model.ObjectMetadata;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=DataEntity.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataEntityFromTable.class, name="TABLE_ENTITY"), @JsonSubTypes.Type(value=DataEntityFromDataStore.class, name="DATA_STORE_ENTITY"), @JsonSubTypes.Type(value=DataEntityFromView.class, name="VIEW_ENTITY"), @JsonSubTypes.Type(value=DataEntityFromSql.class, name="SQL_ENTITY"), @JsonSubTypes.Type(value=DataEntityFromFile.class, name="FILE_ENTITY"), @JsonSubTypes.Type(value=DerivedEntity.class, name="DERIVED_ENTITY")})
@JsonFilter(value="explicitlySetFilter")
public class DataEntity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="entityProperties")
    private final Map<String, String> entityProperties;
    @JsonProperty(value="metadata")
    private final ObjectMetadata metadata;

    @Deprecated
    @ConstructorProperties(value={"entityProperties", "metadata"})
    protected DataEntity(Map<String, String> entityProperties, ObjectMetadata metadata) {
        this.entityProperties = entityProperties;
        this.metadata = metadata;
    }

    public Map<String, String> getEntityProperties() {
        return this.entityProperties;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataEntity(");
        sb.append("super=").append(super.toString());
        sb.append("entityProperties=").append(String.valueOf(this.entityProperties));
        sb.append(", metadata=").append(String.valueOf((Object)this.metadata));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataEntity)) {
            return false;
        }
        DataEntity other = (DataEntity)((Object)o);
        return Objects.equals(this.entityProperties, other.entityProperties) && Objects.equals((Object)this.metadata, (Object)other.metadata) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.entityProperties == null ? 43 : this.entityProperties.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        ViewEntity("VIEW_ENTITY"),
        TableEntity("TABLE_ENTITY"),
        FileEntity("FILE_ENTITY"),
        DataStoreEntity("DATA_STORE_ENTITY"),
        SqlEntity("SQL_ENTITY"),
        DerivedEntity("DERIVED_ENTITY"),
        MessageEntity("MESSAGE_ENTITY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

