/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConnectivityUsageDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="connectionKey")
    private final String connectionKey;
    @JsonProperty(value="action")
    private final String action;
    @JsonProperty(value="consumingService")
    private final String consumingService;

    @Deprecated
    @ConstructorProperties(value={"connectionKey", "action", "consumingService"})
    public ConnectivityUsageDetails(String connectionKey, String action, String consumingService) {
        this.connectionKey = connectionKey;
        this.action = action;
        this.consumingService = consumingService;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getConnectionKey() {
        return this.connectionKey;
    }

    public String getAction() {
        return this.action;
    }

    public String getConsumingService() {
        return this.consumingService;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectivityUsageDetails(");
        sb.append("super=").append(super.toString());
        sb.append("connectionKey=").append(String.valueOf(this.connectionKey));
        sb.append(", action=").append(String.valueOf(this.action));
        sb.append(", consumingService=").append(String.valueOf(this.consumingService));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectivityUsageDetails)) {
            return false;
        }
        ConnectivityUsageDetails other = (ConnectivityUsageDetails)((Object)o);
        return Objects.equals(this.connectionKey, other.connectionKey) && Objects.equals(this.action, other.action) && Objects.equals(this.consumingService, other.consumingService) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.connectionKey == null ? 43 : this.connectionKey.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.consumingService == null ? 43 : this.consumingService.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="connectionKey")
        private String connectionKey;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="consumingService")
        private String consumingService;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder connectionKey(String connectionKey) {
            this.connectionKey = connectionKey;
            this.__explicitlySet__.add("connectionKey");
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder consumingService(String consumingService) {
            this.consumingService = consumingService;
            this.__explicitlySet__.add("consumingService");
            return this;
        }

        public ConnectivityUsageDetails build() {
            ConnectivityUsageDetails model = new ConnectivityUsageDetails(this.connectionKey, this.action, this.consumingService);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConnectivityUsageDetails model) {
            if (model.wasPropertyExplicitlySet("connectionKey")) {
                this.connectionKey(model.getConnectionKey());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("consumingService")) {
                this.consumingService(model.getConsumingService());
            }
            return this;
        }
    }
}

