/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ConfigParameterValue
extends ExplicitlySetBmcModel {
    @JsonProperty(value="stringValue")
    private final String stringValue;
    @JsonProperty(value="intValue")
    private final Integer intValue;
    @JsonProperty(value="objectValue")
    private final Object objectValue;
    @JsonProperty(value="refValue")
    private final Object refValue;
    @JsonProperty(value="parameterValue")
    private final String parameterValue;

    @Deprecated
    @ConstructorProperties(value={"stringValue", "intValue", "objectValue", "refValue", "parameterValue"})
    public ConfigParameterValue(String stringValue, Integer intValue, Object objectValue, Object refValue, String parameterValue) {
        this.stringValue = stringValue;
        this.intValue = intValue;
        this.objectValue = objectValue;
        this.refValue = refValue;
        this.parameterValue = parameterValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public Integer getIntValue() {
        return this.intValue;
    }

    public Object getObjectValue() {
        return this.objectValue;
    }

    public Object getRefValue() {
        return this.refValue;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfigParameterValue(");
        sb.append("super=").append(super.toString());
        sb.append("stringValue=").append(String.valueOf(this.stringValue));
        sb.append(", intValue=").append(String.valueOf(this.intValue));
        sb.append(", objectValue=").append(String.valueOf(this.objectValue));
        sb.append(", refValue=").append(String.valueOf(this.refValue));
        sb.append(", parameterValue=").append(String.valueOf(this.parameterValue));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigParameterValue)) {
            return false;
        }
        ConfigParameterValue other = (ConfigParameterValue)((Object)o);
        return Objects.equals(this.stringValue, other.stringValue) && Objects.equals(this.intValue, other.intValue) && Objects.equals(this.objectValue, other.objectValue) && Objects.equals(this.refValue, other.refValue) && Objects.equals(this.parameterValue, other.parameterValue) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.stringValue == null ? 43 : this.stringValue.hashCode());
        result = result * 59 + (this.intValue == null ? 43 : this.intValue.hashCode());
        result = result * 59 + (this.objectValue == null ? 43 : this.objectValue.hashCode());
        result = result * 59 + (this.refValue == null ? 43 : this.refValue.hashCode());
        result = result * 59 + (this.parameterValue == null ? 43 : this.parameterValue.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stringValue")
        private String stringValue;
        @JsonProperty(value="intValue")
        private Integer intValue;
        @JsonProperty(value="objectValue")
        private Object objectValue;
        @JsonProperty(value="refValue")
        private Object refValue;
        @JsonProperty(value="parameterValue")
        private String parameterValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            this.__explicitlySet__.add("stringValue");
            return this;
        }

        public Builder intValue(Integer intValue) {
            this.intValue = intValue;
            this.__explicitlySet__.add("intValue");
            return this;
        }

        public Builder objectValue(Object objectValue) {
            this.objectValue = objectValue;
            this.__explicitlySet__.add("objectValue");
            return this;
        }

        public Builder refValue(Object refValue) {
            this.refValue = refValue;
            this.__explicitlySet__.add("refValue");
            return this;
        }

        public Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            this.__explicitlySet__.add("parameterValue");
            return this;
        }

        public ConfigParameterValue build() {
            ConfigParameterValue model = new ConfigParameterValue(this.stringValue, this.intValue, this.objectValue, this.refValue, this.parameterValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ConfigParameterValue model) {
            if (model.wasPropertyExplicitlySet("stringValue")) {
                this.stringValue(model.getStringValue());
            }
            if (model.wasPropertyExplicitlySet("intValue")) {
                this.intValue(model.getIntValue());
            }
            if (model.wasPropertyExplicitlySet("objectValue")) {
                this.objectValue(model.getObjectValue());
            }
            if (model.wasPropertyExplicitlySet("refValue")) {
                this.refValue(model.getRefValue());
            }
            if (model.wasPropertyExplicitlySet("parameterValue")) {
                this.parameterValue(model.getParameterValue());
            }
            return this;
        }
    }
}

