/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataconnectivity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dataconnectivity.model.AbstractCallAttribute;
import com.oracle.bmc.dataconnectivity.model.PushDownOperation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CallOperationConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="inFields")
    private final List<String> inFields;
    @JsonProperty(value="outFields")
    private final List<String> outFields;
    @JsonProperty(value="callAttribute")
    private final AbstractCallAttribute callAttribute;
    @JsonProperty(value="pushDownOperations")
    private final List<PushDownOperation> pushDownOperations;

    @Deprecated
    @ConstructorProperties(value={"inFields", "outFields", "callAttribute", "pushDownOperations"})
    public CallOperationConfig(List<String> inFields, List<String> outFields, AbstractCallAttribute callAttribute, List<PushDownOperation> pushDownOperations) {
        this.inFields = inFields;
        this.outFields = outFields;
        this.callAttribute = callAttribute;
        this.pushDownOperations = pushDownOperations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getInFields() {
        return this.inFields;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public AbstractCallAttribute getCallAttribute() {
        return this.callAttribute;
    }

    public List<PushDownOperation> getPushDownOperations() {
        return this.pushDownOperations;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CallOperationConfig(");
        sb.append("super=").append(super.toString());
        sb.append("inFields=").append(String.valueOf(this.inFields));
        sb.append(", outFields=").append(String.valueOf(this.outFields));
        sb.append(", callAttribute=").append(String.valueOf((Object)this.callAttribute));
        sb.append(", pushDownOperations=").append(String.valueOf(this.pushDownOperations));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallOperationConfig)) {
            return false;
        }
        CallOperationConfig other = (CallOperationConfig)((Object)o);
        return Objects.equals(this.inFields, other.inFields) && Objects.equals(this.outFields, other.outFields) && Objects.equals((Object)this.callAttribute, (Object)other.callAttribute) && Objects.equals(this.pushDownOperations, other.pushDownOperations) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.inFields == null ? 43 : this.inFields.hashCode());
        result = result * 59 + (this.outFields == null ? 43 : this.outFields.hashCode());
        result = result * 59 + (this.callAttribute == null ? 43 : this.callAttribute.hashCode());
        result = result * 59 + (this.pushDownOperations == null ? 43 : this.pushDownOperations.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="inFields")
        private List<String> inFields;
        @JsonProperty(value="outFields")
        private List<String> outFields;
        @JsonProperty(value="callAttribute")
        private AbstractCallAttribute callAttribute;
        @JsonProperty(value="pushDownOperations")
        private List<PushDownOperation> pushDownOperations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder inFields(List<String> inFields) {
            this.inFields = inFields;
            this.__explicitlySet__.add("inFields");
            return this;
        }

        public Builder outFields(List<String> outFields) {
            this.outFields = outFields;
            this.__explicitlySet__.add("outFields");
            return this;
        }

        public Builder callAttribute(AbstractCallAttribute callAttribute) {
            this.callAttribute = callAttribute;
            this.__explicitlySet__.add("callAttribute");
            return this;
        }

        public Builder pushDownOperations(List<PushDownOperation> pushDownOperations) {
            this.pushDownOperations = pushDownOperations;
            this.__explicitlySet__.add("pushDownOperations");
            return this;
        }

        public CallOperationConfig build() {
            CallOperationConfig model = new CallOperationConfig(this.inFields, this.outFields, this.callAttribute, this.pushDownOperations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CallOperationConfig model) {
            if (model.wasPropertyExplicitlySet("inFields")) {
                this.inFields(model.getInFields());
            }
            if (model.wasPropertyExplicitlySet("outFields")) {
                this.outFields(model.getOutFields());
            }
            if (model.wasPropertyExplicitlySet("callAttribute")) {
                this.callAttribute(model.getCallAttribute());
            }
            if (model.wasPropertyExplicitlySet("pushDownOperations")) {
                this.pushDownOperations(model.getPushDownOperations());
            }
            return this;
        }
    }
}

